/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.State;
import org.codehaus.cargo.container.spi.jvm.DefaultJvmLauncher;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.maven3.ContainerStartMojo;
import org.codehaus.cargo.maven3.configuration.Container;
import org.codehaus.cargo.maven3.configuration.ZipUrlInstaller;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=false)
public class ContainerRunMojo
extends ContainerStartMojo {
    @Parameter(property="cargo.maven.containerId")
    private String containerId;
    @Parameter(property="cargo.maven.containerUrl")
    private String containerUrl;

    @Override
    public void doExecute() throws MojoExecutionException {
        org.codehaus.cargo.container.Container container = this.createContainer();
        if (!container.getType().isLocal()) {
            throw new MojoExecutionException("Only local containers can be started");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DefaultJvmLauncher.shutdownInProgress = true;
                try {
                    this.stopContainer();
                }
                catch (NumberFormatException ignored) {
                    try {
                        this.stopContainer();
                    }
                    catch (Exception e) {
                        ContainerRunMojo.this.getLog().warn((CharSequence)"Failed stopping the container", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    ContainerRunMojo.this.getLog().warn((CharSequence)"Failed stopping the container", (Throwable)e);
                }
            }

            private void stopContainer() throws Exception {
                if (ContainerRunMojo.this.localContainer != null && (State.STARTED == ContainerRunMojo.this.localContainer.getState() || State.STARTING == ContainerRunMojo.this.localContainer.getState())) {
                    ContainerRunMojo.this.localContainer.stop();
                }
            }
        });
        this.localContainer = (LocalContainer)container;
        this.addAutoDeployDeployable(this.localContainer);
        try {
            this.executeLocalContainerAction();
            this.waitDeployableMonitor((org.codehaus.cargo.container.Container)this.localContainer, true);
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)("Starting container [" + this.localContainer + "] failed"), t);
        }
        this.getLog().info((CharSequence)"Press Ctrl-C to stop the container...");
        ContainerUtils.waitTillContainerIsStopped((org.codehaus.cargo.container.Container)this.localContainer);
    }

    @Override
    protected org.codehaus.cargo.container.Container createNewContainer() throws MojoExecutionException {
        Container containerElement = this.getContainerElement();
        if (this.containerId != null) {
            if (containerElement == null) {
                containerElement = new Container();
                this.setContainerElement(containerElement);
            }
            containerElement.setContainerId(this.containerId);
            containerElement.setType(ContainerType.INSTALLED);
            containerElement.setHome(null);
        }
        if (this.containerUrl != null) {
            if (containerElement == null) {
                throw new MojoExecutionException("If containerUrl is specified alone, an associated <container> element must also be defined in the configuration. Alternatively, you can also define a containerId.");
            }
            containerElement.setType(ContainerType.INSTALLED);
            containerElement.setHome(null);
            ZipUrlInstaller zipUrlInstaller = containerElement.getZipUrlInstaller();
            if (zipUrlInstaller == null) {
                zipUrlInstaller = new ZipUrlInstaller();
                containerElement.setZipUrlInstaller(zipUrlInstaller);
            }
            try {
                URL url = new URL(this.containerUrl);
                zipUrlInstaller.setUrl(url);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Invalid containerUrl", (Exception)e);
            }
            zipUrlInstaller.setExtractDir(null);
        }
        return super.createNewContainer();
    }
}

