/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.concurrent.atomic.AtomicLong;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;

public class TaskBarrier {
    private final AtomicLong state;
    private static final int ushortBits = 16;
    private static final int ushortMask = 65535;
    private static final int TERMINATED = -1;

    private static int nActiveOf(long s) {
        return (int)(s & 0xFFFFL);
    }

    private static int nPartiesOf(long s) {
        return (int)(s & 0xFFFFFFFFFFFF0000L) >>> 16;
    }

    private static int cycleOf(long s) {
        return (int)(s >>> 32);
    }

    private static long stateFor(int cycle, int nParties, int nActive) {
        return (long)cycle << 32 | (long)(nParties << 16 | nActive);
    }

    private void trip(int cycle, int nParties) {
        if (cycle >= 0) {
            if (this.terminate(cycle, nParties)) {
                cycle = -1;
            } else if (++cycle < 0) {
                cycle = 0;
            }
        }
        this.state.set(TaskBarrier.stateFor(cycle, nParties, nParties));
    }

    public TaskBarrier() {
        this(0);
    }

    public TaskBarrier(int parties) {
        if (parties < 0 || parties > 65535) {
            throw new IllegalArgumentException("Too many parties");
        }
        this.state = new AtomicLong(TaskBarrier.stateFor(0, parties, parties));
    }

    public int register() {
        int nActive;
        int nParties;
        int cycle;
        long next;
        long s;
        do {
            if ((nParties = TaskBarrier.nPartiesOf(s = this.state.get()) + 1) > 65535) {
                throw new IllegalStateException("Too many parties");
            }
            nActive = TaskBarrier.nActiveOf(s) + 1;
        } while (!this.state.compareAndSet(s, next = TaskBarrier.stateFor(cycle = TaskBarrier.cycleOf(s), nParties, nActive)));
        return cycle;
    }

    public int arrive() {
        int nParties;
        int cycle;
        block1: {
            int nActive;
            long next;
            long s;
            do {
                s = this.state.get();
                cycle = TaskBarrier.cycleOf(s);
                nParties = TaskBarrier.nPartiesOf(s);
                nActive = TaskBarrier.nActiveOf(s) - 1;
                if (nActive <= 0) break block1;
            } while (!this.state.compareAndSet(s, next = TaskBarrier.stateFor(cycle, nParties, nActive)));
            return cycle;
        }
        this.trip(cycle, nParties);
        return cycle;
    }

    public int arriveAndDeregister() {
        int nParties;
        int cycle;
        block2: {
            int nActive;
            long next;
            long s;
            do {
                s = this.state.get();
                cycle = TaskBarrier.cycleOf(s);
                nParties = TaskBarrier.nPartiesOf(s) - 1;
                if (nParties < 0) {
                    throw new IllegalStateException("Unregistered deregistration");
                }
                nActive = TaskBarrier.nActiveOf(s) - 1;
                if (nActive <= 0) break block2;
            } while (!this.state.compareAndSet(s, next = TaskBarrier.stateFor(cycle, nParties, nActive)));
            return cycle;
        }
        this.trip(cycle, nParties);
        return cycle;
    }

    public int awaitCycleAdvance(int cycle) {
        int p;
        while ((p = this.getCycle()) == cycle && p >= 0) {
            ForkJoinTask<?> t = ForkJoinWorkerThread.pollTask();
            if (t == null) continue;
            p = this.getCycle();
            if (p != cycle) {
                t.fork();
                return p;
            }
            t.exec();
        }
        return p;
    }

    public int arriveAndAwait() {
        int nParties;
        int cycle;
        block1: {
            int nActive;
            long next;
            long s;
            do {
                s = this.state.get();
                cycle = TaskBarrier.cycleOf(s);
                nParties = TaskBarrier.nPartiesOf(s);
                nActive = TaskBarrier.nActiveOf(s) - 1;
                if (nActive <= 0) break block1;
            } while (!this.state.compareAndSet(s, next = TaskBarrier.stateFor(cycle, nParties, nActive)));
            this.awaitCycleAdvance(cycle);
            return nActive;
        }
        this.trip(cycle, nParties);
        return 0;
    }

    public int getCycle() {
        return TaskBarrier.cycleOf(this.state.get());
    }

    public int getRegisteredParties() {
        return TaskBarrier.nPartiesOf(this.state.get());
    }

    public int getActiveParties() {
        return TaskBarrier.nActiveOf(this.state.get());
    }

    public boolean isTerminated() {
        return TaskBarrier.cycleOf(this.state.get()) < 0;
    }

    protected boolean terminate(int cycle, int registeredParties) {
        return registeredParties <= 0;
    }

    public String toString() {
        long s = this.state.get();
        return super.toString() + "[Cycle = " + TaskBarrier.cycleOf(s) + " parties = " + TaskBarrier.nPartiesOf(s) + " active = " + TaskBarrier.nActiveOf(s) + "]";
    }
}

