/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.normal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.api.model.ChoiceScore;
import org.chorem.pollen.votecounting.api.model.MinMaxChoicesNumberConfig;
import org.chorem.pollen.votecounting.api.model.VoteCountingResult;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.api.model.Voter;

public class NormalVoteCountingStrategy
extends AbstractVoteCountingStrategy<MinMaxChoicesNumberConfig> {
    public NormalVoteCountingStrategy() {
        super(MinMaxChoicesNumberConfig.class);
    }

    @Override
    public VoteCountingResult voteCount(Set<Voter> voters) {
        Map<String, ChoiceScore> scores = this.newEmptyChoiceScoreMap(voters);
        for (Voter voter : voters) {
            this.addVoterChoices(voter, scores);
        }
        return this.orderByValues(scores.values(), null);
    }

    protected void addVoterChoices(Voter voter, Map<String, ChoiceScore> scores) {
        double voterWeight = voter.getWeight();
        for (VoteForChoice voteForChoice : voter.getVoteForChoices()) {
            Double voteValue = voteForChoice.getVoteValue();
            if (voteValue == null || voteValue == 0.0) continue;
            ChoiceScore score = scores.get(voteForChoice.getChoiceId());
            score.addScoreValue(voterWeight);
        }
    }

    @Override
    public Set<VoteForChoice> toVoteForChoices(VoteCountingResult voteCountingResult) {
        HashSet voteForChoices = Sets.newHashSet();
        List<ChoiceScore> winners = voteCountingResult.getTopRanking();
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            double score = winners.contains(choiceScore) ? 1.0 : 0.0;
            VoteForChoice voteForChoice = VoteForChoice.newVote(choiceScore.getChoiceId(), score);
            voteForChoices.add(voteForChoice);
        }
        return voteForChoices;
    }
}

