/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.majorityjudgment;

import com.google.common.collect.Multimap;
import java.util.Locale;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCounting;
import org.chorem.pollen.votecounting.api.InvalidVoteCountingConfig;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.impl.majorityjudgment.MajorityJudgmentConfig;
import org.chorem.pollen.votecounting.impl.majorityjudgment.MajorityJudgmentVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class MajorityJudgmentVoteCounting
extends AbstractVoteCounting {
    public MajorityJudgmentVoteCounting() {
        super(VoteCountings.MajorityJudgment);
    }

    public MajorityJudgmentVoteCountingStrategy newStrategy() {
        return new MajorityJudgmentVoteCountingStrategy();
    }

    @Override
    public MajorityJudgmentConfig createConfig() {
        return new MajorityJudgmentConfig();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.SELECT;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(0.0);
    }

    @Override
    public Multimap<String, String> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        Multimap<String, String> errorMap = super.validateVoteForChoice(voteForChoice, config, locale);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue == null) {
            errorMap.put((Object)"voteValue", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.majorityJudgment.voteValue.error.gradeRequired", (Object[])new Object[0]));
        } else if (voteValue != Math.floor(voteValue) || voteValue < 0.0 || voteValue >= (double)InvalidVoteCountingConfig.castVoteCountingConfigOrFail(config, MajorityJudgmentConfig.class).getGrades().size()) {
            errorMap.put((Object)"voteValue", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.majorityJudgment.voteValue.error.gradeUnknown", (Object[])new Object[]{voteValue}));
        }
        return errorMap;
    }
}

