/*
 * #%L
 * Pollen :: VoteCounting Api
 * $Id: VoteCountingStrategy.java 3708 2012-09-29 12:36:25Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.1/pollen-votecounting-api/src/main/java/org/chorem/pollen/votecounting/VoteCountingStrategy.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting;

import org.chorem.pollen.votecounting.model.GroupOfVoter;
import org.chorem.pollen.votecounting.model.GroupVoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.Voter;

import java.util.Set;

/**
 * Strategy of a vote counting.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4.5
 */
public interface VoteCountingStrategy {

    /**
     * Vote count for the given {@code group} of voters and return the
     * result of it.
     *
     * @param group the group of voters and their votes.
     * @return the result of the group vote counting for the given voter.
     */
    GroupVoteCountingResult votecount(GroupOfVoter group);

    /**
     * Vote count for the given {@code voter} and return the result of it.
     *
     * @param voter the voter and their votes.
     * @return the result of the vote counting for the given voter.
     */
    VoteCountingResult votecount(Set<Voter> voter);

}
