/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.security;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.security.AbstractPollenAuthorization;
import org.nuiton.i18n.I18n;

public class PollVoteAccessRequired
extends AbstractPollenAuthorization {
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        SecurityService securityService;
        String errorMessage;
        PollenUserSecurityContext securityContext = this.createSecurityContext(request);
        boolean isAccessAllowed = securityContext.isPollExists();
        if (isAccessAllowed && securityContext.isWithAccountId() && securityContext.hasNoRole()) {
            isAccessAllowed = false;
            this.registerError(request, I18n.n_((String)"pollen.security.error.bad.accountId", (Object[])new Object[0]));
        }
        if (isAccessAllowed && (errorMessage = (securityService = this.getSecurityService(request)).checkCanAccessVote(securityContext)) != null) {
            isAccessAllowed = false;
            this.registerError(request, errorMessage);
        }
        if (isAccessAllowed) {
            PollenUIUtils.setUserSecuritycontext((ServletRequest)request, (PollenUserSecurityContext)securityContext);
        }
        return isAccessAllowed;
    }
}

