/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class AttachPoll
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AttachPoll.class);
    private String pollId;

    public AttachPoll() {
        super(PageSkin.EDITION);
    }

    public String getPollId() {
        return this.pollId == null ? null : this.pollId.trim();
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public String execute() throws Exception {
        String id = this.getPollId();
        UserAccount userAccount = this.getPollenUserAccount();
        Poll poll = this.getPollService().getExistingPollByPollId(id);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Will attach poll %s to user %s", id, userAccount.getEmail()));
        }
        this.getPollService().attachPoll(id, userAccount);
        this.addFlashMessage(this._("pollen.information.poll.attached", new Object[]{poll.getTitle()}));
        return "success";
    }

    public void validate() {
        String id = this.getPollId();
        if (StringUtils.isBlank((CharSequence)id)) {
            this.addFieldError("pollId", this._("pollen.error.pollId.empty", new Object[0]));
        } else {
            try {
                Poll poll = this.getPollService().getExistingPollByPollId(id);
                UserAccount userAccount = poll.getCreator().getUserAccount();
                if (userAccount != null) {
                    this.addFieldError("pollId", this._("pollen.error.pollAlreadyAttached", new Object[0]));
                }
            }
            catch (PollNotFoundException e) {
                this.addFieldError("pollId", this._("pollen.error.pollNotFound", new Object[0]));
            }
        }
    }
}

