<%--
  #%L
  Pollen :: UI (struts2)
  $Id: usersList.jsp 3667 2012-08-29 15:28:07Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/admin/usersList.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<script type="text/javascript"
        src="<s:url value='/js/usersList.js' />"></script>

<title><s:text name="pollen.title.usersList"/></title>

<h1 class="title<s:property value='%{pageLogo}'/>">
  <s:text name="pollen.title.usersList"/>
</h1>

<s:url id="loadUsers" action="getUsers" namespace="/json" escapeAmp="false"/>

<s:set var="user" value="%{#session.pollenSession.userAccount}"/>

<script type="text/javascript">

  var redirectUrl = '<s:url namespace="/admin" action="usersList"/>';
  var deleteTitle = '<s:text name="pollen.action.deleteUser"/>';
  var deleteUrl = '<s:url action="confirmDeleteUser" namespace="/admin"/>';
  var loadUserUrl = '<s:url action="getUser" namespace="/json"/>';
  var editImg = '<s:url value='/img/edit.png'/>';
  var editTitle = '<s:text name="pollen.action.editUser"/>';
  var deleteImg = '<s:url value='/img/delete.png'/>';

  jQuery(document).ready(function () {
    initUsersPage("<s:property value='%{#action.action}'/>",
                  "<s:property value='%{#user.topiaId}'/>");
  });
</script>

<sjg:grid id="users" dataType="json" href="%{loadUsers}" gridModel="users"
          sortable="true" pager="true" pagerButtons="true" pagerInput="true"
          navigator="true" rownumbers="false" autowidth="true"
          onSelectRowTopics='users-rowSelect' editinline="false"
          onCompleteTopics='users-clearSelect'
          navigatorEdit="false" navigatorDelete="false"
          navigatorSearch="false" navigatorRefresh="false"
          navigatorAdd="false" viewrecords="true"
          rowList="10,15,20,50,100" rowNum="10"
          navigatorExtraButtons="{
                add:   { title: '%{getText(\"pollen.action.createUser\")}', icon: 'ui-icon-plus',   topic: 'users-addRow' }}">

  <sjg:gridColumn name="id" title="id" hidden="true"/>
  <sjg:gridColumn name="login" title='%{getText("pollen.common.login")}'/>
  <sjg:gridColumn name="firstName"
                  title='%{getText("pollen.common.firstName")}'/>
  <sjg:gridColumn name="lastName" title='%{getText("pollen.common.lastName")}'/>
  <sjg:gridColumn name="email" title='%{getText("pollen.common.email")}'/>
  <sjg:gridColumn name="administrator" width="20" formatter="checkbox"
                  title='%{getText("pollen.common.administrator")}'/>
  <sjg:gridColumn name="functions" title='%{getText("pollen.common.functions")}'
                  formatter="userFunctions" width="40" sortable="false"/>
</sjg:grid>

<br/>

<s:form id='createForm' method="POST" namespace="/admin"
        cssClass="hidden userForm">

  <s:hidden name="action" value="create"/>
  <fieldset>
    <legend><s:text name="pollen.fieldset.userInformation.toCreate"/></legend>
    <s:textfield key="createUser.login"
                 label="%{getText('pollen.common.login')}" required="true"
                 size="40"/>
    <s:textfield key="createUser.email"
                 label="%{getText('pollen.common.email')}" required="true"
                 size="40"/>
    <s:textfield key="createUser.firstName"
                 label="%{getText('pollen.common.firstName')}" size="40"/>
    <s:textfield key="createUser.lastName"
                 label="%{getText('pollen.common.lastName')}" size="40"/>
    <s:checkbox key="createUser.administrator"
                label="%{getText('pollen.common.administrator')}"/>
  </fieldset>
  <br/>
  <s:submit action="create" key="pollen.action.create" align="center"/>
</s:form>

<s:form id='editForm' method="POST" namespace="/admin"
        cssClass="hidden userForm">

  <s:hidden name="action" value="edit"/>
  <s:hidden key="editUser.topiaId" label=""/>

  <fieldset>
    <legend><s:text name="pollen.fieldset.userInformation.toUpdate"/></legend>
    <s:textfield key="editUser.login" label="%{getText('pollen.common.login')}"
                 required="true" readonly="true" size="40"/>
    <s:textfield key="editUser.email" label="%{getText('pollen.common.email')}"
                 required="true" size="40" disabled="true"/>
    <s:textfield key="editUser.firstName"
                 label="%{getText('pollen.common.firstName')}" size="40"/>
    <s:textfield key="editUser.lastName"
                 label="%{getText('pollen.common.lastName')}" size="40"/>
    <s:checkbox key="editUser.administrator"
                label="%{getText('pollen.common.administrator')}"/>
  </fieldset>
  <br/>
  <s:submit action="edit" key="pollen.action.validate" align="center"/>

</s:form>

<sj:dialog id="confirmDialog" autoOpen="false" modal="true" width="500"/>



