/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;
import org.nuiton.util.StringUtil;

public class Edit
extends PollenActionSupportForEdition {
    private static final long serialVersionUID = 1L;
    protected UserAccount pollenUserAccount;
    protected String newPassword;
    protected String newPassword2;

    public UserAccount getPollenUserAccount() {
        if (this.pollenUserAccount == null) {
            this.pollenUserAccount = this.getUserService().getNewUser();
        }
        return this.pollenUserAccount;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPassword2() {
        return this.newPassword2;
    }

    public void setNewPassword2(String newPassword2) {
        this.newPassword2 = newPassword2;
    }

    public String input() throws Exception {
        UserAccount userAccount = super.getPollenUserAccount();
        this.pollenUserAccount = (UserAccount)this.getUserService().getEntityById(UserAccount.class, userAccount.getTopiaId());
        return "input";
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.pollenUserAccount.getLogin())) {
            this.addFieldError("pollenUserAccount.login", this._("pollen.error.login.required", new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)this.pollenUserAccount.getPassword())) {
            this.addFieldError("pollenUserAccount.password", this._("pollen.error.password.required", new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getNewPassword()) && ObjectUtils.notEqual((Object)this.getNewPassword(), (Object)this.getNewPassword2())) {
            this.addFieldError("newPassword", this._("pollen.error.passwords.not.equals", new Object[0]));
        }
        if (!this.isExists()) {
            if (StringUtils.isBlank((CharSequence)this.pollenUserAccount.getEmail())) {
                this.addFieldError("pollenUserAccount.email", this._("pollen.error.email.required", new Object[0]));
            } else if (!StringUtil.isEmail((String)this.pollenUserAccount.getEmail())) {
                this.addFieldError("pollenUserAccount.email", this._("pollen.error.email.invalid", new Object[0]));
            }
        }
    }

    public String execute() throws Exception {
        this.pollenUserAccount.setAdministrator(super.getPollenUserAccount().isAdministrator());
        String result = "input";
        try {
            UserAccount updatedUser = this.getUserService().updateUser(this.pollenUserAccount, this.newPassword, false);
            this.getPollenSession().setUserAccount(updatedUser);
            this.addFlashMessage(this._("pollen.information.pollAccount.updated", new Object[0]));
            result = "success";
        }
        catch (UserEmailAlreadyUsedException e) {
            this.addFieldError("pollenUserAccount.email", this._("pollen.error.user.email.already.used", new Object[0]));
        }
        catch (UserInvalidPasswordException e) {
            this.addFieldError("pollenUserAccount.password", this._("pollen.error.user.invalid.password", new Object[0]));
        }
        this.pollenUserAccount.setPassword(null);
        this.newPassword2 = null;
        this.newPassword = null;
        return result;
    }

    public boolean isExists() {
        return StringUtils.isNotBlank((CharSequence)this.pollenUserAccount.getTopiaId());
    }
}

