/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.PollenTopiaRootContextFactory;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.chorem.pollen.services.DefaultPollenServiceContext;
import org.chorem.pollen.services.PollenNotifierWorker;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.PollenApplicationContext;
import org.chorem.pollen.ui.PollenUIUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaUtil;

public class PollenApplicationListener
implements ServletContextListener {
    protected static final Log log = LogFactory.getLog(PollenApplicationListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        PollenUIUtils.setServletContext((ServletContext)sce.getServletContext());
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("pollen-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        PollenApplicationContext applicationContext = new PollenApplicationContext();
        PollenApplicationContext.set((ServletContext)sce.getServletContext(), (PollenApplicationContext)applicationContext);
        PollenConfiguration configuration = new PollenConfiguration();
        applicationContext.setConfiguration(configuration);
        if (log.isInfoEnabled()) {
            log.info((Object)"Initializing RootContext...");
        }
        PollenTopiaRootContextFactory factory = new PollenTopiaRootContextFactory();
        TopiaContext rootContext = factory.newDatabaseFromConfig(configuration);
        applicationContext.setRootContext(rootContext);
        try {
            this.initDB(applicationContext);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not init db", (Throwable)e);
        }
        this.initPollenNotifierworker(applicationContext);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext servletContext;
        PollenApplicationContext applicationContext;
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        if ((applicationContext = PollenApplicationContext.get((ServletContext)(servletContext = sce.getServletContext()))) != null) {
            this.closePollenNotifierWorker(applicationContext.getPollenNotifierWorker());
            this.closeRootcontext(applicationContext.getRootContext());
        }
    }

    private void initPollenNotifierworker(PollenApplicationContext applicationContext) {
        PollenServiceContext serviceContext = DefaultPollenServiceContext.newContext((Locale)Locale.getDefault(), null, (PollenConfiguration)applicationContext.getConfiguration(), (PollenServiceFactory)new PollenServiceFactory());
        PollenNotifierWorker pollenNotifierWorker = new PollenNotifierWorker(serviceContext, applicationContext.getRootContext());
        applicationContext.setPollenNotifierWorker(pollenNotifierWorker);
        pollenNotifierWorker.run();
    }

    private void closePollenNotifierWorker(PollenNotifierWorker pollenNotifierWorker) {
        block4: {
            if (pollenNotifierWorker != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Shuting down pollenNotifierWorker... " + pollenNotifierWorker));
                }
                try {
                    pollenNotifierWorker.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Could not close pollenNotifierWorker", (Throwable)e);
                }
            }
        }
    }

    private void closeRootcontext(TopiaContext rootContext) {
        block5: {
            if (rootContext != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Shuting down RootContext... " + rootContext));
                }
                if (!rootContext.isClosed()) {
                    try {
                        rootContext.closeContext();
                    }
                    catch (TopiaException te) {
                        if (!log.isErrorEnabled()) break block5;
                        log.error((Object)"Could not close rootContext", (Throwable)te);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDB(PollenApplicationContext applicationContext) throws TopiaException {
        TopiaContext rootContext = applicationContext.getRootContext();
        boolean schemaFound = TopiaUtil.isSchemaExist((TopiaContext)rootContext, (String)PollenDAOHelper.PollenEntityEnum.UserAccount.getImplementation().getName());
        if (!schemaFound) {
            rootContext.updateSchema();
        }
        PollenConfiguration configuration = applicationContext.getConfiguration();
        PollenServiceFactory serviceFactory = new PollenServiceFactory();
        TopiaContext transaction = rootContext.beginTransaction();
        try {
            PollenServiceContext serviceContext = DefaultPollenServiceContext.newContext((Locale)Locale.getDefault(), (TopiaContext)transaction, (PollenConfiguration)configuration, (PollenServiceFactory)serviceFactory);
            UserService service = (UserService)serviceFactory.newService(UserService.class, serviceContext);
            int nbUsers = service.getNbUsers();
            if (nbUsers == 0) {
                service.createDefaultUsers();
                transaction.commitTransaction();
            }
        }
        finally {
            this.closeTransaction(transaction);
        }
    }

    protected void closeTransaction(TopiaContext tx) throws TopiaException {
        if (tx != null && !tx.isClosed()) {
            tx.closeContext();
        }
    }
}

