/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenServiceFactory;
import org.nuiton.topia.TopiaContext;

public class DefaultPollenServiceContext
implements PollenServiceContext {
    protected TopiaContext transaction;
    protected PollenServiceFactory serviceFactory;
    protected PollenConfiguration configuration;
    protected Locale locale;

    public static PollenServiceContext newContext(PollenServiceContext serviceContext, TopiaContext transaction) {
        return DefaultPollenServiceContext.newContext(serviceContext.getLocale(), transaction, serviceContext.getConfiguration(), serviceContext.getServiceFactory());
    }

    public static PollenServiceContext newContext(Locale locale, TopiaContext transaction, PollenConfiguration configuration, PollenServiceFactory serviceFactory) {
        return new DefaultPollenServiceContext(locale, transaction, configuration, serviceFactory);
    }

    protected DefaultPollenServiceContext(Locale locale, TopiaContext transaction, PollenConfiguration configuration, PollenServiceFactory serviceFactory) {
        this.locale = locale;
        this.transaction = transaction;
        this.configuration = configuration;
        this.serviceFactory = serviceFactory;
    }

    @Override
    public TopiaContext getTransaction() {
        Preconditions.checkNotNull((Object)this.transaction);
        return this.transaction;
    }

    @Override
    public void setTransaction(TopiaContext transaction) {
        this.transaction = transaction;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public URL getApplicationURL() {
        return this.getConfiguration().getApplicationUrl();
    }

    @Override
    public boolean isCanSendEmail() {
        return this.getApplicationURL() != null;
    }

    @Override
    public <E extends PollenService> E newService(Class<E> clazz) {
        return this.serviceFactory.newService(clazz, this);
    }

    @Override
    public PollenConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PollenServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    @Override
    public Date getCurrentTime() {
        return new Date();
    }
}

