/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.bean;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;

public class UserPoll
implements Serializable {
    private static final long serialVersionUID = 7293352208965578801L;
    public static final String PROPERTY_POLL = "poll";
    public static final String PROPERTY_ACCOUNTS = "accounts";
    public static final String PROPERTY_CREATOR = "creator";
    protected Boolean creator;
    protected Poll poll;
    protected List<PollAccount> accounts;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public boolean isCreator() {
        if (this.creator == null) {
            for (PollAccount account : this.accounts) {
                if (!account.equals(this.poll.getCreator())) continue;
                this.creator = true;
                break;
            }
            if (this.creator == null) {
                this.creator = false;
            }
        }
        return this.creator;
    }

    public String getPollUid() {
        return this.poll.getPollId();
    }

    public List<PollAccount> getAccounts() {
        if (this.accounts == null) {
            this.accounts = new ArrayList<PollAccount>();
        }
        return this.accounts;
    }

    public boolean addAccount(PollAccount account) {
        boolean result = this.getAccounts().add(account);
        return result;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public void setPoll(Poll poll) {
        Poll oldValue = this.getPoll();
        this.poll = poll;
        this.firePropertyChange(PROPERTY_POLL, oldValue, poll);
    }

    public void setAccounts(List<PollAccount> accounts) {
        List<PollAccount> oldValue = this.getAccounts();
        this.accounts = accounts;
        this.firePropertyChange(PROPERTY_ACCOUNTS, oldValue, accounts);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        this.firePropertyChange(propertyName, null, newValue);
    }
}

