/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.bean;

import org.chorem.pollen.bean.PollUri;

public class PollUrl {
    private String baseUrl;
    private PollUri pollUri;

    public static PollUrl newPollUrl(String baseUrl, PollUri pollUri) {
        PollUrl result = new PollUrl();
        result.baseUrl = baseUrl;
        result.pollUri = pollUri;
        return result;
    }

    public static PollUrl newPollUrl(PollUrl pollUrl, String accountId) {
        PollUrl result = new PollUrl();
        result.baseUrl = pollUrl.getBaseUrl();
        String pollId = pollUrl.getPollUri().getPollId();
        result.pollUri = PollUri.newPollUri(pollId, accountId);
        return result;
    }

    private PollUrl() {
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public PollUri getPollUri() {
        return this.pollUri;
    }

    public String getUrl() {
        String result = this.getBaseUrl() + this.getPollUri().getUri();
        return result;
    }

    public String toString() {
        return this.getUrl();
    }
}

