/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class PreventRuleAbstract extends TopiaEntityAbstract implements PreventRule {

    /**
     * Nom de l'attribut en BD : scope
     */
    protected String scope;

    /**
     * Nom de l'attribut en BD : sensibility
     */
    protected int sensibility;

    /**
     * Nom de l'attribut en BD : repeated
     */
    protected boolean repeated;

    /**
     * Nom de l'attribut en BD : active
     */
    protected boolean active;

    /**
     * Nom de l'attribut en BD : oneTime
     */
    protected boolean oneTime;

    /**
     * Nom de l'attribut en BD : method
     */
    protected String method;

    /**
     * Nom de l'attribut en BD : poll
     */
    protected Poll poll;

    private static final long serialVersionUID = 7161115041481110320L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_SCOPE, String.class, scope);
        visitor.visit(this, PROPERTY_SENSIBILITY, int.class, sensibility);
        visitor.visit(this, PROPERTY_REPEATED, boolean.class, repeated);
        visitor.visit(this, PROPERTY_ACTIVE, boolean.class, active);
        visitor.visit(this, PROPERTY_ONE_TIME, boolean.class, oneTime);
        visitor.visit(this, PROPERTY_METHOD, String.class, method);
        visitor.visit(this, PROPERTY_POLL, Poll.class, poll);
        visitor.end(this);
    }

    @Override
    public void setScope(String scope) {
        String oldValue = this.scope;
        fireOnPreWrite(PROPERTY_SCOPE, oldValue, scope);
        this.scope = scope;
        fireOnPostWrite(PROPERTY_SCOPE, oldValue, scope);
    }

    @Override
    public String getScope() {
        fireOnPreRead(PROPERTY_SCOPE, scope);
        String result = this.scope;
        fireOnPostRead(PROPERTY_SCOPE, scope);
        return result;
    }

    @Override
    public void setSensibility(int sensibility) {
        int oldValue = this.sensibility;
        fireOnPreWrite(PROPERTY_SENSIBILITY, oldValue, sensibility);
        this.sensibility = sensibility;
        fireOnPostWrite(PROPERTY_SENSIBILITY, oldValue, sensibility);
    }

    @Override
    public int getSensibility() {
        fireOnPreRead(PROPERTY_SENSIBILITY, sensibility);
        int result = this.sensibility;
        fireOnPostRead(PROPERTY_SENSIBILITY, sensibility);
        return result;
    }

    @Override
    public void setRepeated(boolean repeated) {
        boolean oldValue = this.repeated;
        fireOnPreWrite(PROPERTY_REPEATED, oldValue, repeated);
        this.repeated = repeated;
        fireOnPostWrite(PROPERTY_REPEATED, oldValue, repeated);
    }

    @Override
    public boolean isRepeated() {
        fireOnPreRead(PROPERTY_REPEATED, repeated);
        boolean result = this.repeated;
        fireOnPostRead(PROPERTY_REPEATED, repeated);
        return result;
    }

    @Override
    public void setActive(boolean active) {
        boolean oldValue = this.active;
        fireOnPreWrite(PROPERTY_ACTIVE, oldValue, active);
        this.active = active;
        fireOnPostWrite(PROPERTY_ACTIVE, oldValue, active);
    }

    @Override
    public boolean isActive() {
        fireOnPreRead(PROPERTY_ACTIVE, active);
        boolean result = this.active;
        fireOnPostRead(PROPERTY_ACTIVE, active);
        return result;
    }

    @Override
    public void setOneTime(boolean oneTime) {
        boolean oldValue = this.oneTime;
        fireOnPreWrite(PROPERTY_ONE_TIME, oldValue, oneTime);
        this.oneTime = oneTime;
        fireOnPostWrite(PROPERTY_ONE_TIME, oldValue, oneTime);
    }

    @Override
    public boolean isOneTime() {
        fireOnPreRead(PROPERTY_ONE_TIME, oneTime);
        boolean result = this.oneTime;
        fireOnPostRead(PROPERTY_ONE_TIME, oneTime);
        return result;
    }

    @Override
    public void setMethod(String method) {
        String oldValue = this.method;
        fireOnPreWrite(PROPERTY_METHOD, oldValue, method);
        this.method = method;
        fireOnPostWrite(PROPERTY_METHOD, oldValue, method);
    }

    @Override
    public String getMethod() {
        fireOnPreRead(PROPERTY_METHOD, method);
        String result = this.method;
        fireOnPostRead(PROPERTY_METHOD, method);
        return result;
    }

    @Override
    public void setPoll(Poll poll) {
        Poll oldValue = this.poll;
        fireOnPreWrite(PROPERTY_POLL, oldValue, poll);
        this.poll = poll;
        fireOnPostWrite(PROPERTY_POLL, oldValue, poll);
    }

    @Override
    public Poll getPoll() {
        fireOnPreRead(PROPERTY_POLL, poll);
        Poll result = this.poll;
        fireOnPostRead(PROPERTY_POLL, poll);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PreventRuleAbstract
