/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.utils;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.ChoiceTypeDAO;
import org.chorem.pollen.business.persistence.PollTypeDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.persistence.VoteCountingDAO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.business.utils.PropertiesLoader;
import org.hibernate.exception.SQLGrammarException;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaDAO;

public class ContextUtil {
    private static ContextUtil instance = null;
    private TopiaContext context;
    private Properties conf;
    private static final Log log = LogFactory.getLog(ContextUtil.class);

    public TopiaContext getContext() {
        return this.context;
    }

    public Properties getConf() {
        return this.conf;
    }

    public void buildContext() {
        if (this.context == null || this.context.isClosed()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Construction du contexte global...");
                }
                this.context = TopiaContextFactory.getContext((Properties)this.conf);
            }
            catch (TopiaNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Erreur lors de la construction du contexte", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public void closeContext() {
        if (this.context != null && !this.context.isClosed()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Fermeture du contexte global...");
                }
                this.context.closeContext();
            }
            catch (TopiaException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Erreur lors de la fermeture du contexte", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public static ContextUtil getInstance() {
        if (instance == null) {
            instance = new ContextUtil();
        }
        return instance;
    }

    protected String getPropertiesFileName() {
        String filename;
        block3: {
            filename = null;
            try {
                InitialContext jndiContext = new InitialContext();
                filename = (String)jndiContext.lookup("configurationfilename");
            }
            catch (NamingException e) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)"JNDI context not found (normal launch, jndi only exist in winstone launch)");
                if (!log.isTraceEnabled()) break block3;
                log.trace((Object)"Can't get jndi", (Throwable)e);
            }
        }
        if (filename == null || filename.isEmpty()) {
            filename = "pollen.properties";
        }
        return filename;
    }

    private ContextUtil() {
        block4: {
            this.context = null;
            String propertiesFilename = this.getPropertiesFileName();
            this.conf = PropertiesLoader.loadPropertiesFile(propertiesFilename);
            this.conf.setProperty("topia.persistence.classes", PollenModelDAOHelper.getImplementationClassesAsString());
            this.conf.setProperty("topia.service.migration.version", PollenModelDAOHelper.getModelVersion());
            this.buildContext();
            try {
                this.initDB();
            }
            catch (TopiaException e) {
                log.error((Object)"Base de donn\u00e9es inexistante");
                if (!(e.getCause() instanceof SQLGrammarException)) break block4;
                log.info((Object)"Cr\u00e9ation de la base de donn\u00e9es...");
                try {
                    this.context.createSchema();
                    log.info((Object)"Base de donn\u00e9es cr\u00e9\u00e9e");
                    this.initDB();
                }
                catch (TopiaException ex) {
                    log.error((Object)"\u00c9chec lors de la cr\u00e9ation de la base", (Throwable)ex);
                }
            }
        }
    }

    protected void initDB() throws TopiaException {
        TopiaContext transaction = null;
        transaction = this.context.beginTransaction();
        ChoiceTypeDAO choiceTypeDAO = PollenModelDAOHelper.getChoiceTypeDAO(transaction);
        this.loadDB("choiceType", choiceTypeDAO);
        transaction.commitTransaction();
        PollTypeDAO pollTypeDAO = PollenModelDAOHelper.getPollTypeDAO(transaction);
        this.loadDB("pollType", pollTypeDAO);
        transaction.commitTransaction();
        VoteCountingDAO voteCountingDAO = PollenModelDAOHelper.getVoteCountingDAO(transaction);
        this.loadDB("voteCounting", voteCountingDAO);
        transaction.commitTransaction();
        UserAccountDAO userAccountDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
        this.loadAdmin(userAccountDAO);
        transaction.commitTransaction();
        transaction.closeContext();
    }

    private void loadDB(String element, TopiaDAO dao) throws TopiaException {
        if (dao.findAll().size() == 0) {
            String strType = this.conf.getProperty(element);
            String[] tabTypes = strType.split(",");
            for (int i = 0; i < tabTypes.length; ++i) {
                dao.create(new Object[]{"name", tabTypes[i]});
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Types " + element + " cr\u00e9\u00e9s."));
            }
        }
    }

    private void loadAdmin(UserAccountDAO dao) throws TopiaException {
        if (dao.findAllByAdministrator(true).size() == 0) {
            UserAccount userEntity = (UserAccount)dao.create(new Object[0]);
            userEntity.setLogin(this.conf.getProperty("adminLogin"));
            userEntity.setPassword(MD5.encode(this.conf.getProperty("adminPassword")));
            userEntity.setEmail(this.conf.getProperty("adminEmail"));
            userEntity.setAdministrator(true);
            if (log.isInfoEnabled()) {
                log.info((Object)("Utilisateur " + userEntity.getLogin() + " cr\u00e9\u00e9."));
            }
        }
    }

    public static void doCatch(TopiaException e, TopiaContext transaction) {
        ContextUtil.doCatch((Exception)((Object)e), transaction, "\u00c9chec lors du d\u00e9roulement de la transaction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCatch(Exception eee, TopiaContext transaction, String message) {
        if (log.isErrorEnabled()) {
            log.error((Object)message, (Throwable)eee);
        }
        if (transaction != null) {
            try {
                transaction.rollbackTransaction();
            }
            catch (TopiaException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"\u00c9chec lors du rollback de la transaction", (Throwable)ex);
                }
            }
            finally {
                block15: {
                    try {
                        transaction.closeContext();
                    }
                    catch (TopiaException ex) {
                        if (!log.isErrorEnabled()) break block15;
                        log.error((Object)"\u00c9chec lors de la fermeture de la transaction", (Throwable)ex);
                    }
                }
            }
        }
    }
}

