/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataPreventRuleConverter;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.PreventRuleDAO;
import org.chorem.pollen.business.services.ServicePreventRule;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServicePreventRuleImpl
implements ServicePreventRule {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private PreventRuleDAO preventRuleDAO = null;
    private DataPreventRuleConverter converter = new DataPreventRuleConverter();
    private static final Log log = LogFactory.getLog(ServicePreventRuleImpl.class);

    @Override
    public String createPreventRule(PreventRuleDTO preventRule) {
        TopiaContext transaction = null;
        String topiaId = "";
        try {
            transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.create(new Object[0]);
            this.converter.setTransaction(transaction);
            this.converter.populatePreventRuleEntity(preventRule, preventRuleEntity);
            topiaId = preventRuleEntity.getTopiaId();
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return "";
        }
    }

    @Override
    public List<PreventRule> createPreventRules(List<PreventRuleDTO> preventRules, String pollId, TopiaContext trans) {
        if (preventRules.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<PreventRule> result = null;
        try {
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(trans);
            this.converter.setTransaction(trans);
            result = new ArrayList<PreventRule>();
            for (PreventRuleDTO preventRule : preventRules) {
                PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.create(new Object[0]);
                preventRule.setId(preventRuleEntity.getTopiaId());
                preventRule.setPollId(pollId);
                this.converter.populatePreventRuleEntity(preventRule, preventRuleEntity);
                result.add(preventRuleEntity);
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, trans);
            return null;
        }
    }

    @Override
    public boolean updatePreventRule(PreventRuleDTO preventRuleDTO) {
        TopiaContext transaction = null;
        boolean resu = false;
        try {
            transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.findByTopiaId(preventRuleDTO.getId());
            if (preventRuleEntity != null) {
                this.converter.setTransaction(transaction);
                this.converter.populatePreventRuleEntity(preventRuleDTO, preventRuleEntity);
                this.preventRuleDAO.update(preventRuleEntity);
                transaction.commitTransaction();
                resu = true;
            }
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + preventRuleDTO.getId()));
            }
            return resu;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public boolean deletePreventRule(String preventRuleId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.findByTopiaId(preventRuleId);
            this.preventRuleDAO.delete(preventRuleEntity);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + preventRuleId));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public PreventRuleDTO findPreventRuleById(String preventRuleId) {
        TopiaContext transaction = null;
        PreventRuleDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(transaction);
            PreventRule preventRuleEntity = (PreventRule)this.preventRuleDAO.findByTopiaId(preventRuleId);
            if (preventRuleEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createPreventRuleDTO(preventRuleEntity);
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public List<PreventRuleDTO> selectPreventRules(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<PreventRuleDTO> results = null;
        List preventRuleEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.preventRuleDAO = PollenModelDAOHelper.getPreventRuleDAO(transaction);
            if (properties == null) {
                preventRuleEntities = this.preventRuleDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : toutes les r\u00e8gles de notification ont \u00e9t\u00e9 s\u00e9lectionn\u00e9es !");
                }
            } else {
                preventRuleEntities = this.preventRuleDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createPreventRuleDTOs(preventRuleEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }
}

