/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataCommentConverter;
import org.chorem.pollen.business.dto.CommentDTO;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.services.ServiceComment;
import org.chorem.pollen.business.services.ServicePollAccountImpl;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceCommentImpl
implements ServiceComment {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private CommentDAO commentDAO = null;
    private DataCommentConverter converter = new DataCommentConverter();
    private static final Log log = LogFactory.getLog(ServiceCommentImpl.class);

    @Override
    public String createComment(CommentDTO comment) {
        TopiaContext transaction = null;
        String topiaId = "";
        try {
            transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(transaction);
            Comment commentEntity = (Comment)this.commentDAO.create(new Object[0]);
            this.converter.setTransaction(transaction);
            this.converter.populateCommentEntity(comment, commentEntity);
            ServicePollAccountImpl spa = new ServicePollAccountImpl();
            commentEntity.setPollAccount(spa.createPollAccount(comment.getPollAccountId(), null, null));
            topiaId = commentEntity.getTopiaId();
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return "";
        }
    }

    @Override
    public List<Comment> createComments(List<CommentDTO> comments, String pollId, TopiaContext trans) {
        if (comments.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<Comment> result = null;
        try {
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(trans);
            this.converter.setTransaction(trans);
            result = new ArrayList<Comment>();
            for (CommentDTO comment : comments) {
                Comment commentEntity = (Comment)this.commentDAO.create(new Object[0]);
                comment.setPollId(pollId);
                this.converter.populateCommentEntity(comment, commentEntity);
                result.add(commentEntity);
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, trans);
            return null;
        }
    }

    @Override
    public boolean updateComment(CommentDTO comment) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(transaction);
            Comment commentEntity = (Comment)this.commentDAO.findByTopiaId(comment.getId());
            this.converter.setTransaction(transaction);
            this.converter.populateCommentEntity(comment, commentEntity);
            this.commentDAO.update(commentEntity);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + comment.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public boolean deleteComment(String commentId) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(transaction);
            Comment commentEntity = (Comment)this.commentDAO.findByTopiaId(commentId);
            this.commentDAO.delete(commentEntity);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + commentId));
            }
            return true;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return false;
        }
    }

    @Override
    public CommentDTO findCommentById(String commentId) {
        TopiaContext transaction = null;
        CommentDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(transaction);
            Comment commentEntity = (Comment)this.commentDAO.findByTopiaId(commentId);
            if (commentEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createCommentDTO(commentEntity);
            }
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }

    @Override
    public List<CommentDTO> selectComments(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<CommentDTO> results = null;
        List commentEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.commentDAO = PollenModelDAOHelper.getCommentDAO(transaction);
            if (properties == null) {
                commentEntities = this.commentDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les commentaires ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                commentEntities = this.commentDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(transaction);
            results = this.converter.createCommentDTOs(commentEntities);
            transaction.commitTransaction();
            transaction.closeContext();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
            return null;
        }
    }
}

