package org.chorem.lima.ui.fiscalControlExport;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.ui.common.EntryBookComboBoxModel;
import org.chorem.lima.ui.common.FiscalPeriodComboBoxModel;
import static org.nuiton.i18n.I18n.t;

public class FiscalControlExportView extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EXPORT_FILE = "exportFile";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSemNhJ7EJp3EQpbVUDReWHtC5CAqmpQpo0Vls5bdVEbYUvjHcn9pTZnWVmFm8UFSFx4ciNK9y5IHHjhDhw5sAF8S8gxIEr6pvZtddrj5ulzWGTnXnfe9/75s2X/f4vVJYCvfoIx7EjokBRnzi3rj18eKf7iLjqOpGuoKHiAiU/cyVU6qCaN1qXCr3eaWt4M4U3t7kf8oAEY+j1NqpKdciI7BOiFDqfR7hSNvdG2+txGIlh1hEpW9Zv//m79LX3xXclhOIQ2J2EVhrHobJO5tuoRD2FlqHSZ7jJcNADGoIGPeD7ol7bZljK29gnn6LP0UIbVUIsIJlCrxVv2eQw+DiEzg+odDHb5oESnO3EIReqxYV/nWLGewptcNFz3D4XxHcY9bETUccCcVrTa/cpGYShKVVRqEqS3JQRhU7oZhzKHf2axSz0ceAxIhTaeb6yN5I8WebFi7fu4oCwy6Curh07cgC6OsmqDlrKWFzcx11GIHQtd3YJwuzpyOUR4FTC7C4RlHtt3CVssopZ1NErI9CZcRCcV5dv8XiXexr8nqV7l/s+D9KGLais19O2zAqt5BgN1/Ok6jAy4nCL80+uqdtkMKL9Sj7sbD5sgv3l2ex3hrgZ1FftifVuI0/hJUlh8h9gEeRJLk8d+bv6/XT+iCsuDlzNtZ4TZStSigc65u0sNJlb/eakOwKdzQ0G2IWT2UV2n+c6qCwiWIZJ6kw7zD3YSrxlbcJbdEKz+99q/fef/vyxNW4oK9bQMT+Eix4KHsI1orr0ycRNIkVZcxeH6x20JAkDMzVmec5CbC/dBnJQ75S5qxru3MCyDynKC3/8/Mvqx7+9gEotVGUcey2s42+iJdUXoAJnXhx+uGkYnRgswvNlzU2hsqJK3//zZi5sF/oAvCcGSc5ZJBnx6i79+m9974fNoSxzQPPMzPBMmvJHqEIDRgNinDY1Uauz1kJJIo9nZmmzT3Scf4bpaL9vnlemJCnBmDI9vwCB6T+y3dzHCs0rEoPJvzFbtTFcHOlaG0YW/dcmsjnUcczgsBbhgnlEaDu+chSQQaOYK7WpVPdS5JtvPbbRsTrU/9Nq7chuFZlal2aqlUfaCNp8sAC/muKc7dNw3xBoFiTgpKic4h8co/jISQvIPcNVCzQ0T10gjmoD8FntkGHQKzCNxpp3qZQAsfGZ8O4iPJKSNVNy6N1VMB3Kg5uGYurotnLpVvEyF2YfnPk1WTpZtZZOtgpcthWPHOCIqW3GJbkD5o11AdDqqocVbnRp4IGaG1NF5vSzWqBAheFDHpn/Y18+e5ayzz2sP2+uJj7awAo+ULuRIs9MTS9/9RRa9YK0ko+AGUkuFKLxzVMyXHruRt6BDE8A4eVnhOAMAAA=";
    private static final Log log = LogFactory.getLog(FiscalControlExportView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton cancel;
    protected JComboBox entryBookAtNewComboBox;
    protected EntryBookComboBoxModel entryBookAtNewComboBoxModel;
    protected JLabel entryBookAtNewLabel;
    protected JButton export;
    protected File exportFile;
    protected FiscalControlExportView fiscalControlExportFormDialog = this;
    protected JComboBox fiscalPeriodComboBox;
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    protected JLabel fiscalPeriodLabel;
    protected FiscalControlExportViewHandler handler;
    protected JLabel sirenWarnLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        void $afterCompleteSetup() {
            handler.init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FiscalControlExportView() {
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Frame param0) {
        super(param0);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Window param0) {
        super(param0);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FiscalControlExportView(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FiscalControlExportView(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doActionPerformed__on__export(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().export();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getCancel() {
        return cancel;
    }

    public JComboBox getEntryBookAtNewComboBox() {
        return entryBookAtNewComboBox;
    }

    public EntryBookComboBoxModel getEntryBookAtNewComboBoxModel() {
        return entryBookAtNewComboBoxModel;
    }

    public JLabel getEntryBookAtNewLabel() {
        return entryBookAtNewLabel;
    }

    public JButton getExport() {
        return export;
    }

    public File getExportFile() {
        return exportFile;
    }

    public JComboBox getFiscalPeriodComboBox() {
        return fiscalPeriodComboBox;
    }

    public FiscalPeriodComboBoxModel getFiscalPeriodComboBoxModel() {
        return fiscalPeriodComboBoxModel;
    }

    public JLabel getFiscalPeriodLabel() {
        return fiscalPeriodLabel;
    }

    public FiscalControlExportViewHandler getHandler() {
        return handler;
    }

    public JLabel getSirenWarnLabel() {
        return sirenWarnLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setExportFile(File exportFile) {
        File oldValue = this.exportFile;
        this.exportFile = exportFile;
        firePropertyChange(PROPERTY_EXPORT_FILE, oldValue, exportFile);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFiscalControlExportFormDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add($JPanel0, BorderLayout.CENTER);
        add($JPanel1, BorderLayout.SOUTH);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createEntryBookAtNewComboBox() {
        $objectMap.put("entryBookAtNewComboBox", entryBookAtNewComboBox = new JComboBox());
        
        entryBookAtNewComboBox.setName("entryBookAtNewComboBox");
        entryBookAtNewComboBox.setToolTipText(t("lima.fiscalControlExport.entryBookAtNew.toolTip"));
    }

    protected void createEntryBookAtNewComboBoxModel() {
        $objectMap.put("entryBookAtNewComboBoxModel", entryBookAtNewComboBoxModel = new EntryBookComboBoxModel());
    }

    protected void createEntryBookAtNewLabel() {
        $objectMap.put("entryBookAtNewLabel", entryBookAtNewLabel = new JLabel());
        
        entryBookAtNewLabel.setName("entryBookAtNewLabel");
        entryBookAtNewLabel.setText(t("lima.fiscalControlExport.entryBookAtNew"));
    }

    protected void createExport() {
        $objectMap.put("export", export = new JButton());
        
        export.setName("export");
        export.setText(t("lima.fiscalControlExport.export"));
        export.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__export"));
    }

    protected void createExportFile() {
        $objectMap.put("exportFile", exportFile = null);
    }

    protected void createFiscalPeriodComboBox() {
        $objectMap.put("fiscalPeriodComboBox", fiscalPeriodComboBox = new JComboBox());
        
        fiscalPeriodComboBox.setName("fiscalPeriodComboBox");
    }

    protected void createFiscalPeriodComboBoxModel() {
        $objectMap.put("fiscalPeriodComboBoxModel", fiscalPeriodComboBoxModel = new FiscalPeriodComboBoxModel());
    }

    protected void createFiscalPeriodLabel() {
        $objectMap.put("fiscalPeriodLabel", fiscalPeriodLabel = new JLabel());
        
        fiscalPeriodLabel.setName("fiscalPeriodLabel");
        fiscalPeriodLabel.setText(t("lima.fiscalControlExport.fiscalPeriod"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FiscalControlExportViewHandler(this));
    }

    protected void createSirenWarnLabel() {
        $objectMap.put("sirenWarnLabel", sirenWarnLabel = new JLabel());
        
        sirenWarnLabel.setName("sirenWarnLabel");
        sirenWarnLabel.setText(t("lima.fiscalControlExport.sirenMissing"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFiscalControlExportFormDialog();
        // inline complete setup of $JPanel0
        $JPanel0.add($Table0, BorderLayout.CENTER);
        $JPanel0.add(sirenWarnLabel, BorderLayout.SOUTH);
        // inline complete setup of $Table0
        $Table0.add(fiscalPeriodLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fiscalPeriodComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(entryBookAtNewLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(entryBookAtNewComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel1
        $JPanel1.add(cancel);
        $JPanel1.add(export);
        
        // apply 13 property setters
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        fiscalPeriodComboBox.setModel(fiscalPeriodComboBoxModel);
        entryBookAtNewComboBox.setModel(entryBookAtNewComboBoxModel);
        fiscalPeriodLabel.setLabelFor(fiscalPeriodComboBox);
        fiscalPeriodComboBox.setRenderer(new org.chorem.lima.ui.common.FiscalPeriodListRenderer());
        entryBookAtNewLabel.setLabelFor(entryBookAtNewComboBox);
        entryBookAtNewComboBox.setRenderer(new org.chorem.lima.ui.common.EntryBookListRenderer());
        sirenWarnLabel.setIcon(SwingUtil.createImageIcon("warning.png"));
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        export.setIcon(SwingUtil.createActionIcon("export"));
        // late initializer
        fiscalControlExportFormDialog.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("fiscalControlExportFormDialog", fiscalControlExportFormDialog);
        createExportFile();
        createHandler();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFiscalPeriodLabel();
        createFiscalPeriodComboBoxModel();
        createFiscalPeriodComboBox();
        createEntryBookAtNewLabel();
        createEntryBookAtNewComboBoxModel();
        createEntryBookAtNewComboBox();
        createSirenWarnLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createCancel();
        createExport();
        // inline creation of fiscalControlExportFormDialog
        setName("fiscalControlExportFormDialog");
        fiscalControlExportFormDialog.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.fiscalControlExport.form"));
        
        getRootPane().setDefaultButton(export);$completeSetup();
    }

}