// Targeted by JavaCPP version 1.5.3: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_tracking;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import org.bytedeco.opencv.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_tracking.*;


/** \addtogroup tracking
 *  \{
<p>
/************************************ TrackerFeature Base Classes ************************************/

/** \brief Abstract base class for TrackerFeature that represents the feature.
 */
@Namespace("cv") @Properties(inherit = org.bytedeco.opencv.presets.opencv_tracking.class)
public class TrackerFeature extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TrackerFeature(Pointer p) { super(p); }


  /** \brief Compute the features in the images collection
    @param images The images
    @param response The output response
     */
  public native void compute( @Const @ByRef MatVector images, @ByRef Mat response );

  /** \brief Create TrackerFeature by tracker feature type
    @param trackerFeatureType The TrackerFeature name
    <p>
    The modes available now:
    <p>
    -   "HAAR" -- Haar Feature-based
    <p>
    The modes that will be available soon:
    <p>
    -   "HOG" -- Histogram of Oriented Gradients features
    -   "LBP" -- Local Binary Pattern features
    -   "FEATURE2D" -- All types of Feature2D
     */
  public static native @Ptr @ByVal TrackerFeature create( @Str BytePointer trackerFeatureType );
  public static native @Ptr @ByVal TrackerFeature create( @Str String trackerFeatureType );

  /** \brief Identify most effective features
    @param response Collection of response for the specific TrackerFeature
    @param npoints Max number of features
    <p>
    \note This method modifies the response parameter
     */
  public native void selection( @ByRef Mat response, int npoints );

  /** \brief Get the name of the specific TrackerFeature
     */
  public native @Str BytePointer getClassName();
}
