/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.kernel.impl;

import boofcv.alg.filter.kernel.KernelMath;
import boofcv.alg.filter.kernel.SteerableCoefficients;
import boofcv.alg.filter.kernel.SteerableKernel;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;

public class SteerableKernel_F32
implements SteerableKernel<Kernel2D_F32> {
    private Kernel2D_F32 output;
    private SteerableCoefficients coef;
    private Kernel2D[] basis;

    @Override
    public void setBasis(SteerableCoefficients coef, Kernel2D ... basis) {
        this.coef = coef;
        this.basis = basis;
        int width = basis[0].width;
        this.output = new Kernel2D_F32(width);
    }

    @Override
    public Kernel2D_F32 compute(double angle) {
        KernelMath.fill(this.output, 0.0f);
        int N = this.output.width * this.output.width;
        for (int i = 0; i < this.basis.length; ++i) {
            float c = (float)this.coef.compute(angle, i);
            Kernel2D_F32 k = (Kernel2D_F32)this.basis[i];
            for (int j = 0; j < N; ++j) {
                int n = j;
                this.output.data[n] = this.output.data[n] + k.data[j] * c;
            }
        }
        return this.output;
    }

    @Override
    public int getBasisSize() {
        return this.basis.length;
    }

    @Override
    public Kernel2D_F32 getBasis(int index) {
        return (Kernel2D_F32)this.basis[index];
    }
}

