/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.align.util.RotationAxis;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;

public class SymmetryAxes {
    private final List<Axis> axes = new ArrayList<Axis>();

    public void addAxis(Matrix4d axis, int order, CESymmParameters.SymmetryType type) {
        this.axes.add(new Axis(axis, order, type, this.axes.size(), 0));
    }

    private int[] getAxisCounts(int repeat) {
        int[] counts = new int[this.getNumLevels()];
        for (int i = counts.length - 1; i >= 0; --i) {
            int d = this.axes.get(i).getOrder();
            counts[i] = repeat % d;
            repeat /= d;
        }
        assert (repeat == 0) : "Invalid repeat index";
        return counts;
    }

    public void updateAxis(Integer index, Matrix4d newAxis) {
        this.axes.get(index).setOperator(newAxis);
    }

    public List<Matrix4d> getElementaryAxes() {
        ArrayList<Matrix4d> ops = new ArrayList<Matrix4d>(this.getNumLevels());
        for (Axis axis : this.axes) {
            ops.add(axis.getOperator());
        }
        return ops;
    }

    public List<Axis> getElementaryAxesObjects() {
        return this.axes;
    }

    public List<List<Integer>> getRepeatRelation(int level) {
        return this.getRepeatRelation(level, 0);
    }

    public List<List<Integer>> getRepeatRelation(Axis axis) {
        return this.getRepeatRelation(axis.getLevel(), axis.getFirstRepeat());
    }

    public List<List<Integer>> getRepeatRelation(int level, int firstRepeat) {
        int d;
        Axis axis = this.axes.get(level);
        int m = this.getNumRepeats(level + 1);
        int n = m * (d = axis.getOrder());
        if (firstRepeat % n != 0) {
            throw new IllegalArgumentException(String.format("Repeat %d cannot start a block at level %s of this tree", firstRepeat, level));
        }
        if (axis.getSymmType() == CESymmParameters.SymmetryType.OPEN) {
            n -= m;
        }
        ArrayList<Integer> repeats = new ArrayList<Integer>(n);
        ArrayList<Integer> equiv = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            repeats.add(i + firstRepeat);
            equiv.add((i + m) % (m * d) + firstRepeat);
        }
        return Arrays.asList(repeats, equiv);
    }

    public List<List<Integer>> getRepeatsCyclicForm(int level, int firstRepeat) {
        int d;
        Axis axis = this.axes.get(level);
        int m = this.getNumRepeats(level + 1);
        int n = m * (d = axis.getOrder());
        if (firstRepeat % n != 0) {
            throw new IllegalArgumentException(String.format("Repeat %d cannot start a block at level %s of this tree", firstRepeat, level));
        }
        if (axis.getSymmType() == CESymmParameters.SymmetryType.OPEN) {
            n -= m;
        }
        ArrayList<List<Integer>> repeats = new ArrayList<List<Integer>>(m);
        for (int i = 0; i < m; ++i) {
            ArrayList<Integer> cycle = new ArrayList<Integer>(d);
            for (int j = 0; j < d; ++j) {
                cycle.add(firstRepeat + i + j * m);
            }
            repeats.add(cycle);
        }
        return repeats;
    }

    public List<List<Integer>> getRepeatsCyclicForm(Axis axis) {
        return this.getRepeatsCyclicForm(axis.getLevel(), axis.getFirstRepeat());
    }

    public List<List<Integer>> getRepeatsCyclicForm(int level) {
        return this.getRepeatsCyclicForm(level, 0);
    }

    public String getRepeatsCyclicForm(Axis axis, List<?> repeats) {
        if (repeats.size() != this.getNumRepeats()) {
            throw new IllegalArgumentException("Mismatch in the number of repeats");
        }
        return SymmetryAxes.getRepeatsCyclicForm(this.getRepeatsCyclicForm(axis), repeats);
    }

    public static String getRepeatsCyclicForm(List<List<Integer>> cycleForm, List<?> repeats) {
        StringBuilder str = new StringBuilder();
        for (List<Integer> cycle : cycleForm) {
            str.append("(");
            Iterator<Integer> cycleIt = cycle.iterator();
            str.append(repeats.get(cycleIt.next()));
            while (cycleIt.hasNext()) {
                str.append(";").append(repeats.get(cycleIt.next()));
            }
            str.append(")");
        }
        return str.toString();
    }

    public Matrix4d getRepeatTransform(int repeat) {
        Matrix4d transform = new Matrix4d();
        transform.setIdentity();
        int[] counts = this.getAxisCounts(repeat);
        for (int t = counts.length - 1; t >= 0; --t) {
            if (counts[t] == 0) continue;
            Matrix4d axis = new Matrix4d(this.axes.get(t).getOperator());
            for (int i = 0; i < counts[t]; ++i) {
                transform.mul(axis);
            }
        }
        return transform;
    }

    public Matrix4d getRepeatTransform(int x, int y) {
        Matrix4d transform = new Matrix4d();
        transform.setIdentity();
        int[] iCounts = this.getAxisCounts(x);
        int[] jCounts = this.getAxisCounts(y);
        int[] counts = new int[iCounts.length];
        for (int k = 0; k < iCounts.length; ++k) {
            counts[k] = iCounts[k] - jCounts[k];
        }
        for (int t = counts.length - 1; t >= 0; --t) {
            int i;
            Matrix4d axis;
            if (counts[t] == 0) continue;
            if (counts[t] > 0) {
                axis = new Matrix4d(this.axes.get(t).getOperator());
                for (i = 0; i < counts[t]; ++i) {
                    transform.mul(axis);
                }
                continue;
            }
            if (counts[t] >= 0) continue;
            axis = new Matrix4d(this.axes.get(t).getOperator());
            axis.invert();
            for (i = 0; i < counts[t]; ++i) {
                transform.mul(axis);
            }
        }
        return transform;
    }

    public List<Axis> getSymmetryAxes() {
        ArrayList<Axis> symmAxes = new ArrayList<Axis>();
        Matrix4d prior = new Matrix4d();
        prior.setIdentity();
        this.getSymmetryAxes(symmAxes, prior, 0, 0);
        return symmAxes;
    }

    private void getSymmetryAxes(List<Axis> symmAxes, Matrix4d prior, int level, int firstRepeat) {
        if (level >= this.getNumLevels()) {
            return;
        }
        Axis elem = this.axes.get(level);
        Matrix4d elemOp = elem.getOperator();
        Matrix4d currAxisOp = new Matrix4d(prior);
        currAxisOp.invert();
        currAxisOp.mul(elemOp);
        currAxisOp.mul(prior);
        Axis currAxis = new Axis(currAxisOp, elem.getOrder(), elem.getSymmType(), level, firstRepeat);
        symmAxes.add(currAxis);
        this.getSymmetryAxes(symmAxes, prior, level + 1, firstRepeat);
        Matrix4d newPrior = new Matrix4d(elemOp);
        newPrior.mul(prior);
        int childSize = this.getNumRepeats(level + 1);
        this.getSymmetryAxes(symmAxes, newPrior, level + 1, firstRepeat + childSize);
        for (int d = 2; d < elem.getOrder(); ++d) {
            newPrior.mul(elemOp, newPrior);
            this.getSymmetryAxes(symmAxes, newPrior, level + 1, firstRepeat + childSize * d);
        }
    }

    public int getNumRepeats() {
        return this.getNumRepeats(0);
    }

    private int getNumRepeats(int level) {
        int size = 1;
        if (level < this.getNumLevels()) {
            for (Axis axis : this.axes.subList(level, this.getNumLevels())) {
                size *= axis.getOrder();
            }
        }
        return size;
    }

    public List<Integer> getFirstRepeats(int level) {
        ArrayList<Integer> firstRepeats = new ArrayList<Integer>();
        int m = this.getNumRepeats(level + 1);
        int d = this.axes.get(level).getOrder();
        int n = m * d;
        for (int firstRepeat = 0; firstRepeat < this.getNumRepeats(); firstRepeat += n) {
            firstRepeats.add(firstRepeat);
        }
        return firstRepeats;
    }

    public Axis getElementaryAxis(int level) {
        return this.axes.get(level);
    }

    public int getNumLevels() {
        return this.axes.size();
    }

    public static class Axis {
        private Matrix4d operator;
        private int order;
        private CESymmParameters.SymmetryType symmType;
        private int level;
        private int firstRepeat;
        private RotationAxis rotAxis;

        public Axis(Matrix4d operator, int order, CESymmParameters.SymmetryType type, int level, int firstRepeat) {
            if (order < 2) {
                throw new IllegalArgumentException("A symmetry axis should divide a structure in > 2 parts");
            }
            if (type != CESymmParameters.SymmetryType.OPEN && type != CESymmParameters.SymmetryType.CLOSED) {
                throw new IllegalArgumentException("Invalid symmetry type. Only OPEN and CLOSED are allowed");
            }
            this.operator = operator;
            this.order = order;
            this.symmType = type;
            this.setLevel(level);
            this.setFirstRepeat(firstRepeat);
            this.rotAxis = null;
        }

        public Matrix4d getOperator() {
            return this.operator;
        }

        public void setOperator(Matrix4d op) {
            this.operator = op;
        }

        public int getOrder() {
            return this.order;
        }

        public CESymmParameters.SymmetryType getSymmType() {
            return this.symmType;
        }

        public RotationAxis getRotationAxis() {
            if (this.rotAxis == null) {
                this.rotAxis = new RotationAxis(this.operator);
            }
            return this.rotAxis;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            if (level < 0) {
                throw new IndexOutOfBoundsException("Level must be positive");
            }
            this.level = level;
        }

        public int getFirstRepeat() {
            return this.firstRepeat;
        }

        public void setFirstRepeat(int firstRepeat) {
            this.firstRepeat = firstRepeat;
        }
    }
}

