/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.quaternary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.quaternary.OperatorResolver;
import org.biojava.nbio.structure.quaternary.OrderedPair;
import org.rcsb.cif.schema.mm.PdbxStructAssembly;
import org.rcsb.cif.schema.mm.PdbxStructAssemblyGen;
import org.rcsb.cif.schema.mm.PdbxStructOperList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiologicalAssemblyBuilder {
    private static final Logger logger = LoggerFactory.getLogger(BiologicalAssemblyBuilder.class);
    public static final String SYM_CHAIN_ID_SEPARATOR = "_";
    public static final String COMPOSED_OPERATOR_SEPARATOR = "x";
    private OperatorResolver operatorResolver;
    private Map<String, Matrix4d> allTransformations;
    private List<String> modelIndex = new ArrayList<String>();

    public BiologicalAssemblyBuilder() {
        this.init();
    }

    public Structure rebuildQuaternaryStructure(Structure asymUnit, List<BiologicalAssemblyTransformation> transformations, boolean useAsymIds, boolean multiModel) {
        this.orderTransformationsByChainId(asymUnit, transformations);
        Structure s = asymUnit.clone();
        HashMap<Integer, EntityInfo> entityInfoMap = new HashMap<Integer, EntityInfo>();
        s.resetModels();
        s.setEntityInfos(new ArrayList<EntityInfo>());
        for (BiologicalAssemblyTransformation transformation : transformations) {
            ArrayList<Chain> chainsToTransform = new ArrayList<Chain>();
            if (useAsymIds) {
                Chain c = asymUnit.getChain(transformation.getChainId());
                chainsToTransform.add(c);
            } else {
                Chain polyC = asymUnit.getPolyChainByPDB(transformation.getChainId());
                List<Chain> nonPolyCs = asymUnit.getNonPolyChainsByPDB(transformation.getChainId());
                Chain waterC = asymUnit.getWaterChainByPDB(transformation.getChainId());
                if (polyC != null) {
                    chainsToTransform.add(polyC);
                }
                if (!nonPolyCs.isEmpty()) {
                    chainsToTransform.addAll(nonPolyCs);
                }
                if (waterC != null) {
                    chainsToTransform.add(waterC);
                }
            }
            for (Chain c : chainsToTransform) {
                EntityInfo entityInfo;
                Chain chain = (Chain)c.clone();
                Calc.transform(chain, transformation.getTransformationMatrix());
                String transformId = transformation.getId();
                if (multiModel) {
                    this.addChainMultiModel(s, chain, transformId);
                } else {
                    this.addChainFlattened(s, chain, transformId);
                }
                if (!entityInfoMap.containsKey(chain.getEntityInfo().getMolId())) {
                    entityInfo = new EntityInfo(chain.getEntityInfo());
                    entityInfoMap.put(chain.getEntityInfo().getMolId(), entityInfo);
                    s.addEntityInfo(entityInfo);
                } else {
                    entityInfo = (EntityInfo)entityInfoMap.get(chain.getEntityInfo().getMolId());
                }
                chain.setEntityInfo(entityInfo);
                entityInfo.addChain(chain);
            }
        }
        s.setBiologicalAssembly(true);
        return s;
    }

    private void orderTransformationsByChainId(Structure asymUnit, List<BiologicalAssemblyTransformation> transformations) {
        final List<String> chainIds = this.getChainIds(asymUnit);
        Collections.sort(transformations, new Comparator<BiologicalAssemblyTransformation>(){

            @Override
            public int compare(BiologicalAssemblyTransformation t1, BiologicalAssemblyTransformation t2) {
                if (t1.getId().equals(t2.getId())) {
                    return chainIds.indexOf(t1.getChainId()) - chainIds.indexOf(t2.getChainId());
                }
                return t1.getId().compareTo(t2.getId());
            }
        });
    }

    private List<String> getChainIds(Structure asymUnit) {
        ArrayList<String> chainIds = new ArrayList<String>();
        for (Chain c : asymUnit.getChains()) {
            String intChainID = c.getId();
            chainIds.add(intChainID);
        }
        return chainIds;
    }

    private void addChainMultiModel(Structure s, Chain newChain, String transformId) {
        int modelCount;
        if (this.modelIndex.size() == 0) {
            this.modelIndex.add("PLACEHOLDER FOR ASYM UNIT");
        }
        if ((modelCount = this.modelIndex.indexOf(transformId)) == -1) {
            this.modelIndex.add(transformId);
            modelCount = this.modelIndex.indexOf(transformId);
        }
        if (modelCount == 0) {
            s.addChain(newChain);
        } else if (modelCount > s.nrModels()) {
            ArrayList<Chain> newModel = new ArrayList<Chain>();
            newModel.add(newChain);
            s.addModel(newModel);
        } else {
            s.addChain(newChain, modelCount - 1);
        }
    }

    private void addChainFlattened(Structure s, Chain newChain, String transformId) {
        newChain.setId(newChain.getId() + SYM_CHAIN_ID_SEPARATOR + transformId);
        newChain.setName(newChain.getName() + SYM_CHAIN_ID_SEPARATOR + transformId);
        s.addChain(newChain);
    }

    public List<BiologicalAssemblyTransformation> getBioUnitTransformationList(PdbxStructAssembly pdbxStructAssembly, int assemblyIndex, PdbxStructAssemblyGen pdbxStructAssemblyGen, PdbxStructOperList pdbxStructOperList) {
        this.init();
        for (int i = 0; i < pdbxStructOperList.getRowCount(); ++i) {
            try {
                Matrix4d m = new Matrix4d();
                m.m00 = pdbxStructOperList.getMatrix11().get(i);
                m.m01 = pdbxStructOperList.getMatrix12().get(i);
                m.m02 = pdbxStructOperList.getMatrix13().get(i);
                m.m10 = pdbxStructOperList.getMatrix21().get(i);
                m.m11 = pdbxStructOperList.getMatrix22().get(i);
                m.m12 = pdbxStructOperList.getMatrix23().get(i);
                m.m20 = pdbxStructOperList.getMatrix31().get(i);
                m.m21 = pdbxStructOperList.getMatrix32().get(i);
                m.m22 = pdbxStructOperList.getMatrix33().get(i);
                m.m03 = pdbxStructOperList.getVector1().get(i);
                m.m13 = pdbxStructOperList.getVector2().get(i);
                m.m23 = pdbxStructOperList.getVector3().get(i);
                m.m30 = 0.0;
                m.m31 = 0.0;
                m.m32 = 0.0;
                m.m33 = 1.0;
                this.allTransformations.put(pdbxStructOperList.getId().get(i), m);
                continue;
            }
            catch (NumberFormatException e) {
                logger.warn("Could not parse a matrix value from pdbx_struct_oper_list for id {}. The operator id will be ignored. Error: {}", (Object)pdbxStructOperList.getId().get(i), (Object)e.getMessage());
            }
        }
        String assemblyId = pdbxStructAssembly.getId().get(assemblyIndex);
        ArrayList<BiologicalAssemblyTransformation> transformations = this.getBioUnitTransformationsListUnaryOperators(assemblyId, pdbxStructAssemblyGen);
        transformations.addAll(this.getBioUnitTransformationsListBinaryOperators(assemblyId, pdbxStructAssemblyGen));
        transformations.trimToSize();
        return transformations;
    }

    private ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationsListBinaryOperators(String assemblyId, PdbxStructAssemblyGen pdbxStructAssemblyGen) {
        ArrayList<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        List<OrderedPair<String>> operators = this.operatorResolver.getBinaryOperators();
        for (int i = 0; i < pdbxStructAssemblyGen.getRowCount(); ++i) {
            if (!pdbxStructAssemblyGen.getAssemblyId().get(i).equals(assemblyId)) continue;
            String[] asymIds = pdbxStructAssemblyGen.getAsymIdList().get(i).split(",");
            this.operatorResolver.parseOperatorExpressionString(pdbxStructAssemblyGen.getOperExpression().get(i));
            for (String chainId : asymIds) {
                for (OrderedPair<String> operator : operators) {
                    Matrix4d original1 = this.allTransformations.get(operator.getElement1());
                    Matrix4d original2 = this.allTransformations.get(operator.getElement2());
                    if (original1 == null || original2 == null) {
                        logger.warn("Could not find matrix operator for operator id {} or {}. Assembly id {} will not contain the composed operator.", new Object[]{operator.getElement1(), operator.getElement2(), assemblyId});
                        continue;
                    }
                    Matrix4d composed = new Matrix4d(original1);
                    composed.mul(original2);
                    BiologicalAssemblyTransformation transform = new BiologicalAssemblyTransformation();
                    transform.setChainId(chainId);
                    transform.setId(operator.getElement1() + COMPOSED_OPERATOR_SEPARATOR + operator.getElement2());
                    transform.setTransformationMatrix(composed);
                    transformations.add(transform);
                }
            }
        }
        return transformations;
    }

    private ArrayList<BiologicalAssemblyTransformation> getBioUnitTransformationsListUnaryOperators(String assemblyId, PdbxStructAssemblyGen pdbxStructAssemblyGen) {
        ArrayList<BiologicalAssemblyTransformation> transformations = new ArrayList<BiologicalAssemblyTransformation>();
        for (int i = 0; i < pdbxStructAssemblyGen.getRowCount(); ++i) {
            String[] asymIds;
            if (!pdbxStructAssemblyGen.getAssemblyId().get(i).equals(assemblyId)) continue;
            this.operatorResolver.parseOperatorExpressionString(pdbxStructAssemblyGen.getOperExpression().get(i));
            List<String> operators = this.operatorResolver.getUnaryOperators();
            for (String chainId : asymIds = pdbxStructAssemblyGen.getAsymIdList().get(i).split(",")) {
                for (String operator : operators) {
                    Matrix4d original = this.allTransformations.get(operator);
                    if (original == null) {
                        logger.warn("Could not find matrix operator for operator id {}. Assembly id {} will not contain the operator.", (Object)operator, (Object)assemblyId);
                        continue;
                    }
                    BiologicalAssemblyTransformation transform = new BiologicalAssemblyTransformation();
                    transform.setChainId(chainId);
                    transform.setId(operator);
                    transform.setTransformationMatrix(original);
                    transformations.add(transform);
                }
            }
        }
        return transformations;
    }

    private void init() {
        this.operatorResolver = new OperatorResolver();
        this.allTransformations = new HashMap<String, Matrix4d>();
    }
}

