/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.io.Serializable;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResidueIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ResidueIdentifier.class);
    private int seqResIndex;

    public ResidueIdentifier(Group g) {
        Chain c = g.getChain();
        if (c == null) {
            logger.warn("Chain is not available for group {}. Contact comparison will not work for this residue", (Object)g.toString());
            this.seqResIndex = -1;
        } else {
            EntityInfo comp = c.getEntityInfo();
            if (comp == null) {
                logger.warn("Compound is not available for group {}. Contact comparison will not work for this residue", (Object)g.toString());
                this.seqResIndex = -1;
            } else {
                this.seqResIndex = comp.getAlignedResIndex(g, c);
            }
        }
    }

    public int getSeqResIndex() {
        return this.seqResIndex;
    }

    public void setSeqResIndex(int seqResIndex) {
        this.seqResIndex = seqResIndex;
    }

    public int hashCode() {
        return this.seqResIndex;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResidueIdentifier other = (ResidueIdentifier)obj;
        return this.seqResIndex == other.seqResIndex;
    }

    public String toString() {
        return String.valueOf(this.seqResIndex);
    }
}

