/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.ce.CeCPMain;
import org.biojava.nbio.structure.align.ce.CeMain;
import org.biojava.nbio.structure.align.fatcat.FatCatFlexible;
import org.biojava.nbio.structure.align.fatcat.FatCatRigid;
import org.biojava.nbio.structure.align.seq.SmithWaterman3Daligner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureAlignmentFactory {
    private static final Logger logger = LoggerFactory.getLogger(StructureAlignmentFactory.class);
    private static List<StructureAlignment> algorithms = new ArrayList<StructureAlignment>();

    public static void addAlgorithm(StructureAlignment alg) {
        try {
            StructureAlignmentFactory.getAlgorithm(alg.getAlgorithmName());
        }
        catch (StructureException e) {
            algorithms.add(alg);
        }
    }

    public static boolean removeAlgorithm(String name) {
        ListIterator<StructureAlignment> algIt = algorithms.listIterator();
        while (algIt.hasNext()) {
            StructureAlignment alg = algIt.next();
            if (!alg.getAlgorithmName().equalsIgnoreCase(name)) continue;
            algIt.remove();
            return true;
        }
        return false;
    }

    public static void clearAlgorithms() {
        algorithms.clear();
    }

    public static StructureAlignment getAlgorithm(String name) throws StructureException {
        for (StructureAlignment algo : algorithms) {
            if (!algo.getAlgorithmName().equalsIgnoreCase(name)) continue;
            try {
                Class<?> c = Class.forName(algo.getClass().getName());
                return (StructureAlignment)c.newInstance();
            }
            catch (ClassNotFoundException e) {
                logger.error("Exception: ", (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                logger.error("Exception: ", (Throwable)e);
                return null;
            }
            catch (InstantiationException e) {
                logger.error("Exception: ", (Throwable)e);
                return null;
            }
        }
        throw new StructureException("Unknown alignment algorithm: " + name);
    }

    public static StructureAlignment[] getAllAlgorithms() {
        return algorithms.toArray(new StructureAlignment[algorithms.size()]);
    }

    public static String[] getAllAlgorithmNames() {
        StructureAlignment[] algos = StructureAlignmentFactory.getAllAlgorithms();
        ArrayList<String> names = new ArrayList<String>();
        for (StructureAlignment alg : algos) {
            names.add(alg.getAlgorithmName());
        }
        return names.toArray(new String[names.size()]);
    }

    static {
        algorithms.add(new CeMain());
        algorithms.add(new CeCPMain());
        FatCatRigid fatcatRigid = new FatCatRigid();
        FatCatFlexible fatcatFlexible = new FatCatFlexible();
        algorithms.add(fatcatRigid);
        algorithms.add(fatcatFlexible);
        algorithms.add(new SmithWaterman3Daligner());
    }
}

