/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.xtal;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.contact.BoundingBox;

public class UnitCellBoundingBox {
    private BoundingBox[][] chainBbs;
    private BoundingBox[] auBbs;
    private int numOperatorsSg;
    private int numPolyChainsAu;

    public UnitCellBoundingBox(int numOperatorsSg, int numPolyChainsAu) {
        this.numOperatorsSg = numOperatorsSg;
        this.numPolyChainsAu = numPolyChainsAu;
        this.chainBbs = new BoundingBox[numOperatorsSg][numPolyChainsAu];
        this.auBbs = new BoundingBox[numOperatorsSg];
    }

    public void setBbs(Structure structure, Matrix4d[] ops, boolean includeHetAtoms) {
        this.setBb(structure, includeHetAtoms, 0);
        for (int i = 1; i < ops.length; ++i) {
            Structure sym = structure.clone();
            Calc.transform(sym, ops[i]);
            this.setBb(sym, includeHetAtoms, i);
        }
    }

    private void setBb(Structure s, boolean includeHetAtoms, int i) {
        this.chainBbs[i] = new BoundingBox[this.numPolyChainsAu];
        List<Chain> polyChains = s.getPolyChains();
        int j = 0;
        for (Chain polyChain : polyChains) {
            this.chainBbs[i][j] = new BoundingBox(StructureTools.getAllNonHCoordsArray(polyChain, includeHetAtoms));
            ++j;
        }
        this.auBbs[i] = new BoundingBox(this.chainBbs[i]);
    }

    public BoundingBox getChainBoundingBox(int cellIdx, int chainIdx) {
        return this.chainBbs[cellIdx][chainIdx];
    }

    public BoundingBox getAuBoundingBox(int cellIdx) {
        return this.auBbs[cellIdx];
    }

    public UnitCellBoundingBox getTranslatedBbs(Vector3d translation) {
        UnitCellBoundingBox translatedBbs = new UnitCellBoundingBox(this.numOperatorsSg, this.numPolyChainsAu);
        for (int i = 0; i < this.numOperatorsSg; ++i) {
            for (int j = 0; j < this.numPolyChainsAu; ++j) {
                translatedBbs.chainBbs[i][j] = new BoundingBox(this.chainBbs[i][j]);
                translatedBbs.chainBbs[i][j].translate(translation);
            }
            translatedBbs.auBbs[i] = new BoundingBox(translatedBbs.chainBbs[i]);
        }
        return translatedBbs;
    }
}

