/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ResidueGroup {
    private final List<Integer> residues;

    public ResidueGroup(Set<Integer> component) {
        this.residues = new ArrayList<Integer>(component);
        Collections.sort(this.residues);
    }

    public int order() {
        return this.residues.size();
    }

    public boolean isCompatible(ResidueGroup other) {
        if (this.order() != other.order()) {
            return false;
        }
        if (this.residues.get(0) > other.residues.get(0)) {
            return other.isCompatible(this);
        }
        for (int i = 0; i < this.order() - 1; ++i) {
            if (other.residues.get(i) > this.residues.get(i + 1)) {
                return false;
            }
            if (this.residues.get(i) <= other.residues.get(i + 1)) continue;
            return false;
        }
        return true;
    }

    public void combineWith(List<List<Integer>> alignRes) {
        for (int i = 0; i < this.order(); ++i) {
            alignRes.get(i).add(this.residues.get(i));
        }
    }
}

