/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.rcsb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Set;
import java.util.TreeSet;

public class PdbIdLists {
    public static final String SERVICELOCATION = "http://www.rcsb.org/pdb/rest/search";

    public static Set<String> getCurrentPDBIds() throws IOException {
        String xml = "<orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.HoldingsQuery</queryType>\n    <description>Holdings : All Structures</description>\n    <experimentalMethod>ignore</experimentalMethod>\n    <moleculeType>ignore</moleculeType>\n  </orgPdbQuery>";
        return PdbIdLists.postQuery(xml);
    }

    public static Set<String> getAllViruses() throws IOException {
        String xml = "<orgPdbQuery>\n        <version>head</version>\n        <queryType>org.pdb.query.simple.EntriesOfEntitiesQuery</queryType>\n        <description>Entries of :Oligomeric state Search : Min Number of oligomeric state=PAU\n        and\n        TaxonomyTree Search for Viruses\n                </description>\n        <parent><![CDATA[<orgPdbCompositeQuery version=\"1.0\">\n        <queryRefinement>\n        <queryRefinementLevel>0</queryRefinementLevel>\n        <orgPdbQuery>\n        <version>head</version>\n        <queryType>org.pdb.query.simple.BiolUnitQuery</queryType>\n        <description>Oligomeric state Search : Min Number of oligomeric state=PAU </description>\n        <oligomeric_statemin>PAU</oligomeric_statemin>\n        </orgPdbQuery>\n        </queryRefinement>\n        <queryRefinement>\n        <queryRefinementLevel>1</queryRefinementLevel>\n        <conjunctionType>and</conjunctionType>\n        <orgPdbQuery>\n        <version>head</version>\n        <queryType>org.pdb.query.simple.TreeEntityQuery</queryType>\n        <description>TaxonomyTree Search for Viruses</description>\n        <t>1</t>\n        <n>10239</n>\n        <nodeDesc>Viruses</nodeDesc>\n        </orgPdbQuery>\n        </queryRefinement>\n        </orgPdbCompositeQuery>]]></parent>\n        </orgPdbQuery>";
        return PdbIdLists.postQuery(xml);
    }

    public static Set<String> getNMRStructures() throws IOException {
        String xml = "<orgPdbCompositeQuery version=\"1.0\">\n <queryRefinement>\n  <queryRefinementLevel>0</queryRefinementLevel>\n  <orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.HoldingsQuery</queryType>\n    <description>Holdings : All Structures</description>\n    <experimentalMethod>ignore</experimentalMethod>\n    <moleculeType>ignore</moleculeType>\n  </orgPdbQuery>\n </queryRefinement>\n <queryRefinement>\n  <queryRefinementLevel>1</queryRefinementLevel>\n  <conjunctionType>and</conjunctionType>\n  <orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.ExpTypeQuery</queryType>\n    <description>Experimental Method is SOLUTION NMR</description>\n    <mvStructure.expMethod.value>SOLUTION NMR</mvStructure.expMethod.value>\n    <mvStructure.expMethod.exclusive>y</mvStructure.expMethod.exclusive>\n  </orgPdbQuery>\n </queryRefinement>\n</orgPdbCompositeQuery>\n";
        return PdbIdLists.postQuery(xml);
    }

    public static Set<String> getGagPolyproteins() throws IOException {
        String xml = "<orgPdbCompositeQuery version=\"1.0\">\n <queryRefinement>\n  <queryRefinementLevel>0</queryRefinementLevel>\n  <orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.HoldingsQuery</queryType>\n    <description>Holdings : All Structures</description>\n    <experimentalMethod>ignore</experimentalMethod>\n    <moleculeType>ignore</moleculeType>\n  </orgPdbQuery>\n </queryRefinement>\n <queryRefinement>\n  <queryRefinementLevel>1</queryRefinementLevel>\n  <conjunctionType>and</conjunctionType>\n  <orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.MacroMoleculeQuery</queryType>\n    <description>Molecule : Gag-Pol polyprotein [A1Z651, O12158, P03355, P03366, P03367, P03369, P04584, P04585, P04586, P04587, P04588, P05896, P05897, P05959, P05961, P0C6F2, P12497, P12499, P18042, P19505 ... ]</description>\n    <macromoleculeName>A1Z651,O12158,P03355,P03366,P03367,P03369,P04584,P04585,P04586,P04587,P04588,P05896,P05897,P05959,P05961,P0C6F2,P12497,P12499,P18042,P19505,P19560,P20875,P24740,P35963,Q699E2,Q70XD7,Q72547,Q7SMT3,Q7SPG9,Q90VT5</macromoleculeName>\n  </orgPdbQuery>\n </queryRefinement>\n</orgPdbCompositeQuery>";
        return PdbIdLists.postQuery(xml);
    }

    public static Set<String> getTransmembraneProteins() throws IOException {
        String xml = "  <orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.TreeQuery</queryType>\n    <description>TransmembraneTree Search for root</description>\n    <t>19</t>\n    <n>0</n>\n    <nodeDesc>root</nodeDesc>\n  </orgPdbQuery>";
        return PdbIdLists.postQuery(xml);
    }

    public static Set<String> getNucleotides() throws IOException {
        String xml = "<orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.ChainTypeQuery</queryType>\n    <description>Chain Type: there is not any Protein chain</description>\n    <containsProtein>N</containsProtein>\n    <containsDna>?</containsDna>\n    <containsRna>?</containsRna>\n    <containsHybrid>?</containsHybrid>\n  </orgPdbQuery>";
        return PdbIdLists.postQuery(xml);
    }

    public static Set<String> getRibosomes() throws IOException {
        String xml = "<orgPdbQuery>\n    <version>head</version>\n    <queryType>org.pdb.query.simple.StructureKeywordsQuery</queryType>\n    <description>StructureKeywordsQuery: struct_keywords.pdbx_keywords.comparator=contains struct_keywords.pdbx_keywords.value=RIBOSOME </description>\n    <struct_keywords.pdbx_keywords.comparator>contains</struct_keywords.pdbx_keywords.comparator>\n    <struct_keywords.pdbx_keywords.value>RIBOSOME</struct_keywords.pdbx_keywords.value>\n  </orgPdbQuery>";
        return PdbIdLists.postQuery(xml);
    }

    public static Set<String> postQuery(String xml) throws IOException {
        URL u = new URL(SERVICELOCATION);
        String encodedXML = URLEncoder.encode(xml, "UTF-8");
        InputStream in = PdbIdLists.doPOST(u, encodedXML);
        TreeSet<String> pdbIds = new TreeSet<String>();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = rd.readLine()) != null) {
                pdbIds.add(line);
            }
            rd.close();
        }
        return pdbIds;
    }

    public static InputStream doPOST(URL url, String data) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setDoOutput(true);
        try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
            wr.write(data);
            wr.flush();
        }
        return conn.getInputStream();
    }

    public static void main(String[] args) {
        try {
            System.out.println("Current PDB status: " + PdbIdLists.getCurrentPDBIds().size());
            System.out.println("Virus structures: " + PdbIdLists.getAllViruses().size());
            System.out.println("NMR structures: " + PdbIdLists.getNMRStructures().size());
            System.out.println("Gag-polyproteins: " + PdbIdLists.getGagPolyproteins().size());
            System.out.println("Transmembrane proteins: " + PdbIdLists.getTransmembraneProteins().size());
            System.out.println("Nucleotide: " + PdbIdLists.getNucleotides().size());
            System.out.println("Ribosomes: " + PdbIdLists.getRibosomes().size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

