/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmtf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ExperimentalTechnique;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIO;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.DownloadChemCompProvider;
import org.biojava.nbio.structure.io.mmcif.chem.ChemCompTools;
import org.biojava.nbio.structure.io.mmcif.model.ChemComp;
import org.biojava.nbio.structure.io.mmtf.MmtfSummaryDataBean;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.secstruc.DSSPParser;
import org.biojava.nbio.structure.secstruc.SecStrucCalc;
import org.biojava.nbio.structure.secstruc.SecStrucState;
import org.biojava.nbio.structure.secstruc.SecStrucType;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.rcsb.mmtf.dataholders.DsspType;
import org.rcsb.mmtf.utils.CodecUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmtfUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MmtfUtils.class);

    public static AtomCache setUpBioJava() {
        AtomCache cache = new AtomCache();
        cache.setUseMmCif(true);
        FileParsingParameters params = cache.getFileParsingParams();
        params.setCreateAtomBonds(true);
        params.setAlignSeqRes(true);
        params.setParseBioAssembly(true);
        DownloadChemCompProvider cc = new DownloadChemCompProvider();
        ChemCompGroupFactory.setChemCompProvider(cc);
        cc.checkDoFirstInstall();
        cache.setFileParsingParams(params);
        StructureIO.setAtomCache(cache);
        return cache;
    }

    public static AtomCache setUpBioJava(String extraUrl) {
        AtomCache cache = new AtomCache();
        cache.setUseMmCif(true);
        FileParsingParameters params = cache.getFileParsingParams();
        params.setCreateAtomBonds(true);
        params.setAlignSeqRes(true);
        params.setParseBioAssembly(true);
        DownloadChemCompProvider.serverBaseUrl = extraUrl;
        DownloadChemCompProvider.useDefaultUrlLayout = false;
        DownloadChemCompProvider cc = new DownloadChemCompProvider();
        ChemCompGroupFactory.setChemCompProvider(cc);
        cc.checkDoFirstInstall();
        cache.setFileParsingParams(params);
        StructureIO.setAtomCache(cache);
        return cache;
    }

    public static void fixMicroheterogenity(Structure bioJavaStruct) {
        for (int i = 0; i < bioJavaStruct.nrModels(); ++i) {
            List<Chain> chains = bioJavaStruct.getModel(i);
            for (Chain c : chains) {
                ArrayList<Group> outGroups = new ArrayList<Group>();
                for (Group g : c.getAtomGroups()) {
                    ArrayList<Group> removeList = new ArrayList<Group>();
                    for (Group altLoc : g.getAltLocs()) {
                        if (altLoc.getPDBName().equals(g.getPDBName())) continue;
                        removeList.add(altLoc);
                    }
                    outGroups.add(g);
                    g.getAltLocs().removeAll(removeList);
                    outGroups.addAll(removeList);
                }
                c.setAtomGroups(outGroups);
            }
        }
    }

    public static void calculateDsspSecondaryStructure(Structure bioJavaStruct) {
        SecStrucCalc ssp = new SecStrucCalc();
        try {
            ssp.calculate(bioJavaStruct, true);
        }
        catch (StructureException e) {
            LOGGER.warn("Could not calculate secondary structure (error {}). Will try to get a DSSP file from the RCSB web server instead.", (Object)e.getMessage());
            try {
                DSSPParser.fetch(bioJavaStruct.getPDBCode(), bioJavaStruct, true);
            }
            catch (Exception bige) {
                LOGGER.warn("Could not get a DSSP file from RCSB web server. There will not be secondary structure assignment for this structure ({}). Error: {}", (Object)bioJavaStruct.getPDBCode(), (Object)bige.getMessage());
            }
        }
    }

    public static String getSpaceGroupAsString(SpaceGroup spaceGroup) {
        if (spaceGroup == null) {
            return "NA";
        }
        return spaceGroup.getShortSymbol();
    }

    public static float[] getUnitCellAsArray(PDBCrystallographicInfo xtalInfo) {
        CrystalCell xtalCell = xtalInfo.getCrystalCell();
        if (xtalCell == null) {
            return null;
        }
        float[] inputUnitCell = new float[]{(float)xtalCell.getA(), (float)xtalCell.getB(), (float)xtalCell.getC(), (float)xtalCell.getAlpha(), (float)xtalCell.getBeta(), (float)xtalCell.getGamma()};
        return inputUnitCell;
    }

    public static String[] techniquesToStringArray(Set<ExperimentalTechnique> experimentalTechniques) {
        if (experimentalTechniques == null) {
            return new String[0];
        }
        String[] outArray = new String[experimentalTechniques.size()];
        int index = 0;
        for (ExperimentalTechnique experimentalTechnique : experimentalTechniques) {
            outArray[index] = experimentalTechnique.getName();
            ++index;
        }
        return outArray;
    }

    public static String dateToIsoString(Date inputDate) {
        SimpleDateFormat dateStringFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateStringFormat.format(inputDate);
    }

    public static Map<double[], int[]> getTransformMap(BioAssemblyInfo bioassemblyInfo, Map<String, Integer> chainIdToIndexMap) {
        LinkedHashMap matMap = new LinkedHashMap();
        List<BiologicalAssemblyTransformation> transforms = bioassemblyInfo.getTransforms();
        for (BiologicalAssemblyTransformation transformation : transforms) {
            Matrix4d transMatrix = transformation.getTransformationMatrix();
            String transChainId = transformation.getChainId();
            if (!chainIdToIndexMap.containsKey(transChainId)) continue;
            int chainIndex = chainIdToIndexMap.get(transformation.getChainId());
            if (matMap.containsKey(transMatrix)) {
                ((List)matMap.get(transMatrix)).add(chainIndex);
                continue;
            }
            ArrayList<Integer> chainIdList = new ArrayList<Integer>();
            chainIdList.add(chainIndex);
            matMap.put(transMatrix, chainIdList);
        }
        LinkedHashMap<double[], int[]> outMap = new LinkedHashMap<double[], int[]>();
        for (Map.Entry entry : matMap.entrySet()) {
            outMap.put(MmtfUtils.convertToDoubleArray((Matrix4d)entry.getKey()), CodecUtils.convertToIntArray((List)((List)entry.getValue())));
        }
        return outMap;
    }

    public static double[] convertToDoubleArray(Matrix4d transformationMatrix) {
        double[] outArray = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                outArray[i * 4 + j] = transformationMatrix.getElement(i, j);
            }
        }
        return outArray;
    }

    public static int getNumGroups(Structure structure) {
        int count = 0;
        for (int i = 0; i < structure.nrModels(); ++i) {
            for (Chain chain : structure.getChains(i)) {
                count += chain.getAtomGroups().size();
            }
        }
        return count;
    }

    public static List<Atom> getAtomsForGroup(Group inputGroup) {
        HashSet<Atom> uniqueAtoms = new HashSet<Atom>();
        ArrayList<Atom> theseAtoms = new ArrayList<Atom>();
        for (Atom a : inputGroup.getAtoms()) {
            theseAtoms.add(a);
            uniqueAtoms.add(a);
        }
        List<Group> altLocs = inputGroup.getAltLocs();
        for (Group thisG : altLocs) {
            for (Atom a : thisG.getAtoms()) {
                if (uniqueAtoms.contains(a)) continue;
                theseAtoms.add(a);
            }
        }
        return theseAtoms;
    }

    public static int getNumBondsInGroup(List<Atom> atomsInGroup) {
        int bondCounter = 0;
        for (Atom atom : atomsInGroup) {
            if (atom.getBonds() == null) continue;
            for (Bond bond : atom.getBonds()) {
                Atom other = bond.getOther(atom);
                if (atomsInGroup.indexOf(other) == -1) continue;
                Integer firstBondIndex = atomsInGroup.indexOf(atom);
                Integer secondBondIndex = atomsInGroup.indexOf(other);
                if (firstBondIndex >= secondBondIndex) continue;
                ++bondCounter;
            }
        }
        return bondCounter;
    }

    public static int getSecStructType(Group group) {
        SecStrucState props = (SecStrucState)group.getProperty("secstruc");
        if (props == null) {
            return DsspType.NULL_ENTRY.getDsspIndex();
        }
        return DsspType.dsspTypeFromString((String)props.getType().name).getDsspIndex();
    }

    public static void setSecStructType(Group group, int dsspIndex) {
        SecStrucType secStrucType = MmtfUtils.getSecStructTypeFromDsspIndex(dsspIndex);
        SecStrucState secStrucState = new SecStrucState(group, "MMTF_ASSIGNED", secStrucType);
        if (secStrucType != null) {
            group.setProperty("secstruc", secStrucState);
        }
    }

    public static SecStrucType getSecStructTypeFromDsspIndex(int dsspIndex) {
        String dsspType = DsspType.dsspTypeFromInt((int)dsspIndex).getDsspType();
        for (SecStrucType secStrucType : SecStrucType.values()) {
            if (!dsspType.equals(secStrucType.name)) continue;
            return secStrucType;
        }
        return null;
    }

    public static MmtfSummaryDataBean getStructureInfo(Structure structure) {
        MmtfSummaryDataBean mmtfSummaryDataBean = new MmtfSummaryDataBean();
        ArrayList<Atom> theseAtoms = new ArrayList<Atom>();
        ArrayList<Chain> allChains = new ArrayList<Chain>();
        LinkedHashMap<String, Integer> chainIdToIndexMap = new LinkedHashMap<String, Integer>();
        int chainCounter = 0;
        int bondCount = 0;
        mmtfSummaryDataBean.setAllAtoms(theseAtoms);
        mmtfSummaryDataBean.setAllChains(allChains);
        mmtfSummaryDataBean.setChainIdToIndexMap(chainIdToIndexMap);
        for (int i = 0; i < structure.nrModels(); ++i) {
            List<Chain> chains = structure.getModel(i);
            allChains.addAll(chains);
            for (Chain chain : chains) {
                String idOne = chain.getId();
                if (!chainIdToIndexMap.containsKey(idOne)) {
                    chainIdToIndexMap.put(idOne, chainCounter);
                }
                ++chainCounter;
                for (Group g : chain.getAtomGroups()) {
                    for (Atom atom : MmtfUtils.getAtomsForGroup(g)) {
                        theseAtoms.add(atom);
                        if (atom.getBonds() == null) continue;
                        bondCount += atom.getBonds().size();
                    }
                }
            }
        }
        mmtfSummaryDataBean.setNumBonds(bondCount / 2);
        return mmtfSummaryDataBean;
    }

    public static Matrix4d[] getNcsAsMatrix4d(double[][] ncsOperMatrixList) {
        if (ncsOperMatrixList == null) {
            return null;
        }
        int numMats = ncsOperMatrixList.length;
        if (numMats == 0) {
            return null;
        }
        if (numMats == 1 && ncsOperMatrixList[0].length == 0) {
            return null;
        }
        Matrix4d[] outList = new Matrix4d[numMats];
        for (int i = 0; i < numMats; ++i) {
            outList[i] = new Matrix4d(ncsOperMatrixList[i]);
        }
        return outList;
    }

    public static double[][] getNcsAsArray(Matrix4d[] ncsOperators) {
        if (ncsOperators == null) {
            return new double[0][0];
        }
        double[][] outList = new double[ncsOperators.length][16];
        for (int i = 0; i < ncsOperators.length; ++i) {
            outList[i] = MmtfUtils.convertToDoubleArray(ncsOperators[i]);
        }
        return outList;
    }

    public static void insertSeqResGroup(Chain chain, Group group, int sequenceIndexId) {
        List<Group> seqResGroups = chain.getSeqResGroups();
        MmtfUtils.addGroupAtId(seqResGroups, group, sequenceIndexId);
    }

    public static void addSeqRes(Chain modelChain, String sequence) {
        List<Group> seqResGroups = modelChain.getSeqResGroups();
        GroupType chainType = MmtfUtils.getChainType(modelChain.getAtomGroups());
        for (int i = 0; i < sequence.length(); ++i) {
            char singleLetterCode = sequence.charAt(i);
            Group group = null;
            if (seqResGroups.size() > i) {
                group = seqResGroups.get(i);
            }
            if (group != null) continue;
            group = MmtfUtils.getSeqResGroup(singleLetterCode, chainType);
            MmtfUtils.addGroupAtId(seqResGroups, group, i);
        }
    }

    private static GroupType getChainType(List<Group> groups) {
        for (Group group : groups) {
            if (group == null || group.getType() == GroupType.HETATM) continue;
            return group.getType();
        }
        return GroupType.HETATM;
    }

    private static <T> void addGroupAtId(List<T> seqResGroups, T group, int sequenceIndexId) {
        while (seqResGroups.size() <= sequenceIndexId) {
            seqResGroups.add(null);
        }
        if (sequenceIndexId >= 0) {
            seqResGroups.set(sequenceIndexId, group);
        }
    }

    private static Group getSeqResGroup(char singleLetterCode, GroupType type) {
        if (type == GroupType.AMINOACID) {
            String threeLetter = ChemCompTools.getAminoThreeLetter(Character.valueOf(singleLetterCode));
            if (threeLetter == null) {
                return null;
            }
            ChemComp chemComp = ChemCompGroupFactory.getChemComp(threeLetter);
            AminoAcidImpl a = new AminoAcidImpl();
            a.setRecordType("SEQRES");
            a.setAminoType(Character.valueOf(singleLetterCode));
            a.setPDBName(threeLetter);
            a.setChemComp(chemComp);
            return a;
        }
        if (type == GroupType.NUCLEOTIDE) {
            String twoLetter = ChemCompTools.getDNATwoLetter(Character.valueOf(singleLetterCode));
            if (twoLetter == null) {
                return null;
            }
            ChemComp chemComp = ChemCompGroupFactory.getChemComp(twoLetter);
            NucleotideImpl n = new NucleotideImpl();
            n.setPDBName(twoLetter);
            n.setChemComp(chemComp);
            return n;
        }
        return null;
    }
}

