/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.mmcif.chem;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum PolymerType implements Serializable
{
    peptide("polypeptide(L)"),
    dpeptide("polypeptide(D)"),
    dna("polydeoxyribonucleotide"),
    rna("polyribonucleotide"),
    dnarna("polydeoxyribonucleotide/polyribonucleotide hybrid"),
    polysaccharide("polysaccharide(D)"),
    lpolysaccharide("polysaccharide(L)"),
    otherPolymer("other"),
    cyclicPeptide("cyclic-pseudo-peptide"),
    peptideNucleicAcid("peptide nucleic acid"),
    unknown(null);

    static Map<String, PolymerType> lookupTable;
    public final String entity_poly_type;
    public static final Set<PolymerType> PROTEIN_ONLY;
    public static final Set<PolymerType> DNA_ONLY;
    public static final Set<PolymerType> RNA_ONLY;
    public static final Set<PolymerType> POLYNUCLEOTIDE_ONLY;
    public static final Set<PolymerType> ALL_POLYMER_TYPES;

    private PolymerType(String entity_poly_type) {
        this.entity_poly_type = entity_poly_type;
    }

    public static PolymerType polymerTypeFromString(String polymerType) {
        if (polymerType.equalsIgnoreCase(PolymerType.peptide.entity_poly_type)) {
            return peptide;
        }
        PolymerType ptype = lookupTable.get(polymerType);
        if (ptype != null) {
            return ptype;
        }
        ptype = lookupTable.get(polymerType.toLowerCase());
        if (ptype != null) {
            return ptype;
        }
        for (PolymerType pt : PolymerType.values()) {
            if (!polymerType.equals(pt.entity_poly_type)) continue;
            return pt;
        }
        return unknown;
    }

    static {
        lookupTable = new HashMap<String, PolymerType>();
        for (PolymerType rt : PolymerType.values()) {
            if (rt == unknown) continue;
            lookupTable.put(rt.entity_poly_type, rt);
            lookupTable.put(rt.entity_poly_type.toLowerCase(), rt);
        }
        HashSet<PolymerType> tmp = new HashSet<PolymerType>();
        tmp.add(peptide);
        PROTEIN_ONLY = Collections.unmodifiableSet(tmp);
        tmp = new HashSet();
        tmp.add(dna);
        DNA_ONLY = Collections.unmodifiableSet(tmp);
        tmp = new HashSet();
        tmp.add(rna);
        RNA_ONLY = Collections.unmodifiableSet(tmp);
        tmp = new HashSet();
        tmp.add(dna);
        tmp.add(rna);
        tmp.add(dnarna);
        POLYNUCLEOTIDE_ONLY = Collections.unmodifiableSet(tmp);
        ALL_POLYMER_TYPES = Collections.unmodifiableSet(new HashSet<PolymerType>(Arrays.asList(PolymerType.values())));
    }
}

