/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io.cif;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.AminoAcidImpl;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.Element;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.HetatomImpl;
import org.biojava.nbio.structure.NucleotideImpl;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.SeqMisMatchImpl;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureImpl;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.io.BondMaker;
import org.biojava.nbio.structure.io.ChargeAdder;
import org.biojava.nbio.structure.io.EntityFinder;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.biojava.nbio.structure.io.cif.CifFileConsumer;
import org.biojava.nbio.structure.io.mmcif.ChemCompGroupFactory;
import org.biojava.nbio.structure.io.mmcif.model.DatabasePdbrevRecord;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.nbio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.nbio.structure.io.mmcif.model.StructConn;
import org.biojava.nbio.structure.quaternary.BioAssemblyInfo;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyBuilder;
import org.biojava.nbio.structure.quaternary.BiologicalAssemblyTransformation;
import org.biojava.nbio.structure.xtal.CrystalCell;
import org.biojava.nbio.structure.xtal.SpaceGroup;
import org.biojava.nbio.structure.xtal.SymoplibParser;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.generated.AtomSite;
import org.rcsb.cif.model.generated.AtomSites;
import org.rcsb.cif.model.generated.AuditAuthor;
import org.rcsb.cif.model.generated.Cell;
import org.rcsb.cif.model.generated.ChemComp;
import org.rcsb.cif.model.generated.ChemCompBond;
import org.rcsb.cif.model.generated.DatabasePDBRemark;
import org.rcsb.cif.model.generated.DatabasePDBRev;
import org.rcsb.cif.model.generated.DatabasePDBRevRecord;
import org.rcsb.cif.model.generated.Entity;
import org.rcsb.cif.model.generated.EntityPoly;
import org.rcsb.cif.model.generated.EntityPolySeq;
import org.rcsb.cif.model.generated.EntitySrcGen;
import org.rcsb.cif.model.generated.EntitySrcNat;
import org.rcsb.cif.model.generated.Exptl;
import org.rcsb.cif.model.generated.PdbxAuditRevisionHistory;
import org.rcsb.cif.model.generated.PdbxChemCompIdentifier;
import org.rcsb.cif.model.generated.PdbxDatabaseStatus;
import org.rcsb.cif.model.generated.PdbxEntityDescriptor;
import org.rcsb.cif.model.generated.PdbxEntitySrcSyn;
import org.rcsb.cif.model.generated.PdbxMolecule;
import org.rcsb.cif.model.generated.PdbxMoleculeFeatures;
import org.rcsb.cif.model.generated.PdbxNonpolyScheme;
import org.rcsb.cif.model.generated.PdbxReferenceEntityLink;
import org.rcsb.cif.model.generated.PdbxReferenceEntityList;
import org.rcsb.cif.model.generated.PdbxReferenceEntityPolyLink;
import org.rcsb.cif.model.generated.PdbxStructModResidue;
import org.rcsb.cif.model.generated.PdbxStructOperList;
import org.rcsb.cif.model.generated.Refine;
import org.rcsb.cif.model.generated.Struct;
import org.rcsb.cif.model.generated.StructAsym;
import org.rcsb.cif.model.generated.StructConf;
import org.rcsb.cif.model.generated.StructConnType;
import org.rcsb.cif.model.generated.StructKeywords;
import org.rcsb.cif.model.generated.StructNcsOper;
import org.rcsb.cif.model.generated.StructRef;
import org.rcsb.cif.model.generated.StructRefSeq;
import org.rcsb.cif.model.generated.StructRefSeqDif;
import org.rcsb.cif.model.generated.StructSheetRange;
import org.rcsb.cif.model.generated.StructSite;
import org.rcsb.cif.model.generated.StructSiteGen;
import org.rcsb.cif.model.generated.Symmetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CifFileConsumerImpl
implements CifFileConsumer<Structure> {
    private static final Logger logger = LoggerFactory.getLogger(CifFileConsumerImpl.class);
    private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd").toFormatter(Locale.US);
    private Structure structure;
    private Chain currentChain;
    private Group currentGroup;
    private List<List<Chain>> allModels;
    private List<Chain> currentModel;
    private PDBHeader pdbHeader;
    private String currentNmrModelNumber;
    private List<Chain> entityChains;
    private Entity entity;
    private EntityPoly entityPoly;
    private EntitySrcGen entitySrcGen;
    private EntitySrcNat entitySrcNat;
    private PdbxEntitySrcSyn entitySrcSyn;
    private List<Chain> seqResChains;
    private org.rcsb.cif.model.generated.PdbxStructAssembly structAssembly;
    private org.rcsb.cif.model.generated.PdbxStructAssemblyGen structAssemblyGen;
    private StructAsym structAsym;
    private org.rcsb.cif.model.generated.StructConn structConn;
    private StructNcsOper structNcsOper;
    private PdbxStructOperList structOpers;
    private StructRef structRef;
    private StructRefSeqDif structRefSeqDif;
    private StructSiteGen structSiteGen;
    private Map<String, String> asymId2entityId;
    private Map<String, String> asymId2authorId;
    private Matrix4d parsedScaleMatrix;
    private FileParsingParameters params;

    public CifFileConsumerImpl(FileParsingParameters params) {
        this.params = params;
    }

    @Override
    public void prepare() {
        this.structure = new StructureImpl();
        this.pdbHeader = new PDBHeader();
        this.structure.setPDBHeader(this.pdbHeader);
        this.allModels = new ArrayList<List<Chain>>();
        this.currentModel = new ArrayList<Chain>();
        this.seqResChains = new ArrayList<Chain>();
        this.asymId2entityId = new HashMap<String, String>();
        this.asymId2authorId = new HashMap<String, String>();
        this.entityChains = new ArrayList<Chain>();
    }

    @Override
    public void consumeAtomSite(AtomSite atomSite) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        StrColumn labelAsymId = atomSite.getLabelAsymId();
        StrColumn authAsymId = atomSite.getAuthAsymId();
        StrColumn groupPDB = atomSite.getGroupPDB();
        IntColumn authSeqId = atomSite.getAuthSeqId();
        StrColumn labelCompId = atomSite.getLabelCompId();
        IntColumn id = atomSite.getId();
        StrColumn labelAtomId = atomSite.getLabelAtomId();
        FloatColumn cartnX = atomSite.getCartnX();
        FloatColumn cartnY = atomSite.getCartnY();
        FloatColumn cartnZ = atomSite.getCartnZ();
        FloatColumn occupancy = atomSite.getOccupancy();
        FloatColumn bIsoOrEquiv = atomSite.getBIsoOrEquiv();
        StrColumn labelAltId = atomSite.getLabelAltId();
        StrColumn typeSymbol = atomSite.getTypeSymbol();
        StrColumn pdbxPDBInsCode = atomSite.getPdbxPDBInsCode();
        IntColumn labelSeqId = atomSite.getLabelSeqId();
        IntColumn pdbx_pdb_model_num = atomSite.getPdbxPDBModelNum();
        for (int atomIndex = 0; atomIndex < atomSite.getRowCount(); ++atomIndex) {
            boolean startOfNewChain = false;
            Character oneLetterCode = StructureTools.get1LetterCodeAmino(labelCompId.get(atomIndex));
            boolean isHetAtmInFile = false;
            if (!"ATOM".equals(groupPDB.get(atomIndex))) {
                if (oneLetterCode != null && oneLetterCode.equals(Character.valueOf('X'))) {
                    oneLetterCode = null;
                }
                isHetAtmInFile = true;
            }
            String insCodeString = pdbxPDBInsCode.get(atomIndex);
            Character insCode = null;
            if (insCodeString != null && !insCodeString.isEmpty() && !"?".equals(insCodeString)) {
                insCode = Character.valueOf(insCodeString.charAt(0));
            }
            long seqId = labelSeqId.get(atomIndex);
            String nmrModelNumber = pdbx_pdb_model_num.getStringData(atomIndex);
            if (this.currentNmrModelNumber == null) {
                this.currentNmrModelNumber = nmrModelNumber;
            }
            if (!this.currentNmrModelNumber.equals(nmrModelNumber)) {
                this.currentNmrModelNumber = nmrModelNumber;
                if (this.currentChain != null) {
                    this.currentChain.addGroup(this.currentGroup);
                    this.currentGroup.trimToSize();
                }
                this.allModels.add(this.currentModel);
                this.currentModel = new ArrayList<Chain>();
                this.currentChain = null;
                this.currentGroup = null;
            }
            String asymId = labelAsymId.get(atomIndex);
            String authId = authAsymId.get(atomIndex);
            if (this.currentChain == null) {
                this.currentChain = new ChainImpl();
                this.currentChain.setName(authId);
                this.currentChain.setId(asymId);
                this.currentModel.add(this.currentChain);
                startOfNewChain = true;
            }
            if (!asymId.equals(this.currentChain.getId())) {
                startOfNewChain = true;
                this.currentChain.addGroup(this.currentGroup);
                Optional<Chain> testChain = this.currentModel.stream().filter(chain -> chain.getId().equals(asymId)).findFirst();
                if (testChain.isPresent()) {
                    this.currentChain = testChain.get();
                } else {
                    this.currentChain = new ChainImpl();
                    this.currentChain.setName(authId);
                    this.currentChain.setId(asymId);
                }
                if (!this.currentModel.contains(this.currentChain)) {
                    this.currentModel.add(this.currentChain);
                }
            }
            ResidueNumber residueNumber = new ResidueNumber(authId, authSeqId.get(atomIndex), insCode);
            String recordName = groupPDB.get(atomIndex);
            String compId = labelCompId.get(atomIndex);
            if (this.currentGroup == null) {
                this.currentGroup = this.createGroup(recordName, oneLetterCode, compId, seqId);
                this.currentGroup.setResidueNumber(residueNumber);
                this.currentGroup.setPDBName(compId);
                this.currentGroup.setHetAtomInFile(isHetAtmInFile);
            }
            Group altGroup = null;
            String altLocation = labelAltId.get(atomIndex);
            if (startOfNewChain) {
                this.currentGroup = this.createGroup(recordName, oneLetterCode, compId, seqId);
                this.currentGroup.setResidueNumber(residueNumber);
                this.currentGroup.setPDBName(compId);
                this.currentGroup.setHetAtomInFile(isHetAtmInFile);
            } else if (!residueNumber.equals(this.currentGroup.getResidueNumber())) {
                this.currentChain.addGroup(this.currentGroup);
                this.currentGroup.trimToSize();
                this.currentGroup = this.createGroup(recordName, oneLetterCode, compId, seqId);
                this.currentGroup.setPDBName(compId);
                this.currentGroup.setResidueNumber(residueNumber);
                this.currentGroup.setHetAtomInFile(isHetAtmInFile);
            } else if (altLocation != null && !altLocation.isEmpty() && !altLocation.equals(".") && (altGroup = this.getAltLocGroup(recordName, Character.valueOf(altLocation.charAt(0)), oneLetterCode, compId, seqId)).getChain() == null) {
                altGroup.setChain(this.currentChain);
            }
            if (this.params.isParseCAOnly() && !labelAtomId.get(atomIndex).equals("CA") && "C".equals(typeSymbol.get(atomIndex))) continue;
            AtomImpl atom = new AtomImpl();
            atom.setPDBserial(id.get(atomIndex));
            atom.setName(labelAtomId.get(atomIndex));
            atom.setX(cartnX.get(atomIndex));
            atom.setY(cartnY.get(atomIndex));
            atom.setZ(cartnZ.get(atomIndex));
            atom.setOccupancy((float)occupancy.get(atomIndex));
            atom.setTempFactor((float)bIsoOrEquiv.get(atomIndex));
            if (altLocation == null || altLocation.isEmpty() || altLocation.equals(".")) {
                atom.setAltLoc(Character.valueOf(' '));
            } else {
                atom.setAltLoc(Character.valueOf(altLocation.charAt(0)));
            }
            String ts = typeSymbol.get(atomIndex);
            try {
                Element element = Element.valueOfIgnoreCase(ts);
                atom.setElement(element);
            }
            catch (IllegalArgumentException e) {
                logger.info("Element {} was not recognised as a BioJava-known element, the element will be represented as the generic element {}", (Object)typeSymbol, (Object)Element.R.name());
                atom.setElement(Element.R);
            }
            if (altGroup != null) {
                altGroup.addAtom(atom);
            } else {
                this.currentGroup.addAtom(atom);
            }
            String atomName = atom.getName();
            if (this.currentGroup.hasAtom(atomName) || !this.currentGroup.getPDBName().equals(atom.getGroup().getPDBName()) || StructureTools.hasNonDeuteratedEquiv(atom, this.currentGroup)) continue;
            this.currentGroup.addAtom(atom);
        }
    }

    private Group getAltLocGroup(String recordName, Character altLoc, Character oneLetterCode, String threeLetterCode, long seqId) {
        Group altLocGroup;
        List<Atom> atoms = this.currentGroup.getAtoms();
        if (atoms.size() > 0 && atoms.get(0).getAltLoc().equals(altLoc)) {
            return this.currentGroup;
        }
        List<Group> altLocs = this.currentGroup.getAltLocs();
        for (Group altLocGroup2 : altLocs) {
            atoms = altLocGroup2.getAtoms();
            if (atoms.size() <= 0) continue;
            for (Atom a1 : atoms) {
                if (!a1.getAltLoc().equals(altLoc)) continue;
                return altLocGroup2;
            }
        }
        if (threeLetterCode.equals(this.currentGroup.getPDBName())) {
            if (this.currentGroup.getAtoms().isEmpty()) {
                return this.currentGroup;
            }
            altLocGroup = (Group)this.currentGroup.clone();
            altLocGroup.setAtoms(new ArrayList<Atom>());
            altLocGroup.getAltLocs().clear();
            this.currentGroup.addAltLoc(altLocGroup);
            return altLocGroup;
        }
        altLocGroup = this.createGroup(recordName, oneLetterCode, threeLetterCode, seqId);
        altLocGroup.setPDBName(threeLetterCode);
        altLocGroup.setResidueNumber(this.currentGroup.getResidueNumber());
        this.currentGroup.addAltLoc(altLocGroup);
        return altLocGroup;
    }

    private Group createGroup(String record, Character oneLetterCode, String threeLetterCode, long seqId) {
        Group group = ChemCompGroupFactory.getGroupFromChemCompDictionary(threeLetterCode);
        if (group != null && !group.getChemComp().isEmpty()) {
            if (group instanceof AminoAcidImpl) {
                AminoAcidImpl aminoAcid = (AminoAcidImpl)group;
                aminoAcid.setId(seqId);
            } else if (group instanceof NucleotideImpl) {
                NucleotideImpl nucleotide = (NucleotideImpl)group;
                nucleotide.setId(seqId);
            } else if (group instanceof HetatomImpl) {
                HetatomImpl hetatom = (HetatomImpl)group;
                hetatom.setId(seqId);
            }
            return group;
        }
        if ("ATOM".equals(record)) {
            if (StructureTools.isNucleotide(threeLetterCode)) {
                NucleotideImpl nucleotide = new NucleotideImpl();
                group = nucleotide;
                nucleotide.setId(seqId);
            } else if (oneLetterCode == null || oneLetterCode.charValue() == 'X') {
                HetatomImpl hetatom = new HetatomImpl();
                group = hetatom;
                hetatom.setId(seqId);
            } else {
                AminoAcidImpl aminoAcid = new AminoAcidImpl();
                group = aminoAcid;
                aminoAcid.setAminoType(oneLetterCode);
                aminoAcid.setId(seqId);
            }
        } else if (StructureTools.isNucleotide(threeLetterCode)) {
            NucleotideImpl nucleotide = new NucleotideImpl();
            group = nucleotide;
            nucleotide.setId(seqId);
        } else if (oneLetterCode != null) {
            AminoAcidImpl aminoAcid = new AminoAcidImpl();
            group = aminoAcid;
            aminoAcid.setAminoType(oneLetterCode);
            aminoAcid.setId(seqId);
        } else {
            HetatomImpl hetatom = new HetatomImpl();
            hetatom.setId(seqId);
            group = hetatom;
        }
        return group;
    }

    @Override
    public void consumeAtomSites(AtomSites atomSites) {
        if (!atomSites.isDefined() || atomSites.getRowCount() == 0) {
            return;
        }
        try {
            this.parsedScaleMatrix = new Matrix4d(atomSites.getFractTransfMatrix11().get(0), atomSites.getFractTransfMatrix12().get(0), atomSites.getFractTransfMatrix13().get(0), atomSites.getFractTransfVector1().get(0), atomSites.getFractTransfMatrix21().get(0), atomSites.getFractTransfMatrix22().get(0), atomSites.getFractTransfMatrix23().get(0), atomSites.getFractTransfVector2().get(0), atomSites.getFractTransfMatrix31().get(0), atomSites.getFractTransfMatrix32().get(0), atomSites.getFractTransfMatrix33().get(0), atomSites.getFractTransfVector3().get(0), 0.0, 0.0, 0.0, 1.0);
        }
        catch (NumberFormatException e) {
            logger.warn("Some values in _atom_sites.fract_transf_matrix or _atom_sites.fract_transf_vector could not be parsed as numbers. Can't check whether coordinate frame convention is correct! Error: {}", (Object)e.getMessage());
            this.structure.getPDBHeader().getCrystallographicInfo().setNonStandardCoordFrameConvention(false);
        }
    }

    @Override
    public void consumeAuditAuthor(AuditAuthor auditAuthor) {
        for (int rowIndex = 0; rowIndex < auditAuthor.getRowCount(); ++rowIndex) {
            String name = auditAuthor.getName().get(rowIndex);
            StringBuilder last = new StringBuilder();
            StringBuilder initials = new StringBuilder();
            boolean afterComma = false;
            for (char c : name.toCharArray()) {
                if (c == ' ') continue;
                if (c == ',') {
                    afterComma = true;
                    continue;
                }
                if (afterComma) {
                    initials.append(c);
                    continue;
                }
                last.append(c);
            }
            StringBuilder newaa = new StringBuilder();
            newaa.append((CharSequence)initials);
            newaa.append((CharSequence)last);
            String auth = this.pdbHeader.getAuthors();
            if (auth == null) {
                this.pdbHeader.setAuthors(newaa.toString());
                continue;
            }
            auth = auth + "," + newaa.toString();
            this.pdbHeader.setAuthors(auth);
        }
    }

    @Override
    public void consumeCell(Cell cell) {
        if (!cell.isDefined() || cell.getRowCount() == 0) {
            return;
        }
        try {
            float a = (float)cell.getLengthA().get(0);
            float b = (float)cell.getLengthB().get(0);
            float c = (float)cell.getLengthC().get(0);
            float alpha = (float)cell.getAngleAlpha().get(0);
            float beta = (float)cell.getAngleBeta().get(0);
            float gamma = (float)cell.getAngleGamma().get(0);
            CrystalCell crystalCell = new CrystalCell();
            crystalCell.setA(a);
            crystalCell.setB(b);
            crystalCell.setC(c);
            crystalCell.setAlpha(alpha);
            crystalCell.setBeta(beta);
            crystalCell.setGamma(gamma);
            if (!crystalCell.isCellReasonable()) {
                logger.debug("The crystal cell read from file does not have reasonable dimensions (at least one dimension is below {}), discarding it.", (Object)10.0);
                return;
            }
            this.structure.getPDBHeader().getCrystallographicInfo().setCrystalCell(crystalCell);
        }
        catch (NumberFormatException e) {
            this.structure.getPDBHeader().getCrystallographicInfo().setCrystalCell(null);
            logger.info("could not parse some cell parameters ({}), ignoring _cell", (Object)e.getMessage());
        }
    }

    @Override
    public void consumeChemComp(ChemComp chemComp) {
    }

    @Override
    public void consumeChemCompBond(ChemCompBond chemCompBond) {
    }

    @Override
    public void consumeDatabasePDBremark(DatabasePDBRemark databasePDBremark) {
        for (int rowIndex = 0; rowIndex < databasePDBremark.getRowCount(); ++rowIndex) {
            String line;
            int i;
            int id = databasePDBremark.getId().get(rowIndex);
            if (id != 2 || (i = (line = databasePDBremark.getText().get(rowIndex)).indexOf("ANGSTROM")) <= 5) continue;
            String resolution = line.substring(i - 5, i).trim();
            try {
                float res = Float.parseFloat(resolution);
                this.pdbHeader.setResolution(res);
                continue;
            }
            catch (NumberFormatException e) {
                logger.info("could not parse resolution from line and ignoring it {}", (Object)line);
                return;
            }
        }
    }

    private Date convert(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    @Override
    public void consumeDatabasePDBrev(DatabasePDBRev databasePDBrev) {
        logger.debug("got a database revision:" + databasePDBrev);
        for (int rowIndex = 0; rowIndex < databasePDBrev.getRowCount(); ++rowIndex) {
            if (databasePDBrev.getNum().get(rowIndex) == 1) {
                String dateOriginal = databasePDBrev.getDateOriginal().get(rowIndex);
                this.pdbHeader.setDepDate(this.convert(LocalDate.parse(dateOriginal, DATE_FORMAT)));
                String date = databasePDBrev.getDate().get(rowIndex);
                this.pdbHeader.setRelDate(this.convert(LocalDate.parse(date, DATE_FORMAT)));
                continue;
            }
            String dbrev = databasePDBrev.getDate().get(rowIndex);
            this.pdbHeader.setModDate(this.convert(LocalDate.parse(dbrev, DATE_FORMAT)));
        }
    }

    @Override
    public void consumeDatabasePDBrevRecord(DatabasePDBRevRecord databasePDBrevRecord) {
        List<DatabasePdbrevRecord> revRecords = this.pdbHeader.getRevisionRecords();
        if (revRecords == null) {
            revRecords = new ArrayList<DatabasePdbrevRecord>();
            this.pdbHeader.setRevisionRecords(revRecords);
        }
        revRecords.addAll(this.convert(databasePDBrevRecord));
    }

    private List<DatabasePdbrevRecord> convert(DatabasePDBRevRecord databasePDBrevRecord) {
        ArrayList<DatabasePdbrevRecord> revRecords = new ArrayList<DatabasePdbrevRecord>();
        for (int rowIndex = 0; rowIndex < databasePDBrevRecord.getRowCount(); ++rowIndex) {
            DatabasePdbrevRecord revRecord = new DatabasePdbrevRecord();
            revRecord.setDetails(databasePDBrevRecord.getDetails().get(rowIndex));
            revRecord.setRev_num(databasePDBrevRecord.getRevNum().getStringData(rowIndex));
            revRecord.setType(databasePDBrevRecord.getType().get(rowIndex));
            revRecords.add(revRecord);
        }
        return revRecords;
    }

    @Override
    public void consumeEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void consumeEntityPoly(EntityPoly entityPoly) {
        this.entityPoly = entityPoly;
    }

    @Override
    public void consumeEntitySrcGen(EntitySrcGen entitySrcGen) {
        this.entitySrcGen = entitySrcGen;
    }

    @Override
    public void consumeEntitySrcNat(EntitySrcNat entitySrcNat) {
        this.entitySrcNat = entitySrcNat;
    }

    @Override
    public void consumeEntitySrcSyn(PdbxEntitySrcSyn entitySrcSyn) {
        this.entitySrcSyn = entitySrcSyn;
    }

    @Override
    public void consumeEntityPolySeq(EntityPolySeq entityPolySeq) {
        for (int rowIndex = 0; rowIndex < entityPolySeq.getRowCount(); ++rowIndex) {
            Chain entityChain = this.getEntityChain(entityPolySeq.getEntityId().get(rowIndex));
            Group g = ChemCompGroupFactory.getGroupFromChemCompDictionary(entityPolySeq.getMonId().get(rowIndex));
            if (g != null && !g.getChemComp().isEmpty()) {
                if (g instanceof AminoAcidImpl) {
                    AminoAcidImpl aa = (AminoAcidImpl)g;
                    aa.setRecordType("SEQRES");
                }
            } else if (entityPolySeq.getMonId().get(rowIndex).length() == 3 && StructureTools.get1LetterCodeAmino(entityPolySeq.getMonId().get(rowIndex)) != null) {
                AminoAcidImpl a = new AminoAcidImpl();
                a.setRecordType("SEQRES");
                Character code1 = StructureTools.get1LetterCodeAmino(entityPolySeq.getMonId().get(rowIndex));
                a.setAminoType(code1);
                g = a;
            } else if (StructureTools.isNucleotide(entityPolySeq.getMonId().get(rowIndex))) {
                g = new NucleotideImpl();
            } else {
                logger.debug("Residue {} {} is not a standard aminoacid or nucleotide, will create a het group for it", (Object)entityPolySeq.getNum().get(rowIndex), (Object)entityPolySeq.getMonId().get(rowIndex));
                g = new HetatomImpl();
            }
            g.setResidueNumber(ResidueNumber.fromString(entityPolySeq.getNum().getStringData(rowIndex)));
            g.setPDBName(entityPolySeq.getMonId().get(rowIndex));
            entityChain.addGroup(g);
        }
    }

    private Chain getEntityChain(String entityId) {
        for (Chain chain : this.entityChains) {
            if (!chain.getId().equals(entityId)) continue;
            return chain;
        }
        ChainImpl chain = new ChainImpl();
        chain.setId(entityId);
        this.entityChains.add(chain);
        return chain;
    }

    @Override
    public void consumeExptl(Exptl exptl) {
        for (int rowIndex = 0; rowIndex < exptl.getRowCount(); ++rowIndex) {
            this.pdbHeader.setExperimentalTechnique(exptl.getMethod().get(rowIndex));
        }
    }

    @Override
    public void consumePdbxAuditRevisionHistory(PdbxAuditRevisionHistory pdbxAuditRevisionHistory) {
        for (int rowIndex = 0; rowIndex < pdbxAuditRevisionHistory.getRowCount(); ++rowIndex) {
            if (pdbxAuditRevisionHistory.getOrdinal().get(rowIndex) == 1) {
                String release = pdbxAuditRevisionHistory.getRevisionDate().get(rowIndex);
                this.pdbHeader.setRelDate(this.convert(LocalDate.parse(release, DATE_FORMAT)));
                continue;
            }
            String revision = pdbxAuditRevisionHistory.getRevisionDate().get(rowIndex);
            this.pdbHeader.setModDate(this.convert(LocalDate.parse(revision, DATE_FORMAT)));
        }
    }

    @Override
    public void consumePdbxChemCompIdentifier(PdbxChemCompIdentifier pdbxChemCompIdentifier) {
    }

    @Override
    public void consumePdbxDatabaseStatus(PdbxDatabaseStatus pdbxDatabaseStatus) {
        for (int rowIndex = 0; rowIndex < pdbxDatabaseStatus.getRowCount(); ++rowIndex) {
            StrColumn recvdInitialDepositionDate = pdbxDatabaseStatus.getRecvdInitialDepositionDate();
            if (!recvdInitialDepositionDate.isDefined()) continue;
            String deposition = recvdInitialDepositionDate.get(rowIndex);
            this.pdbHeader.setDepDate(this.convert(LocalDate.parse(deposition, DATE_FORMAT)));
        }
    }

    @Override
    public void consumePdbxEntityDescriptor(PdbxEntityDescriptor pdbxEntityDescriptor) {
    }

    @Override
    public void consumePdbxMolecule(PdbxMolecule pdbxMolecule) {
    }

    @Override
    public void consumePdbxMoleculeFeatures(PdbxMoleculeFeatures pdbxMoleculeFeatures) {
    }

    @Override
    public void consumePdbxNonpolyScheme(PdbxNonpolyScheme pdbxNonpolyScheme) {
    }

    @Override
    public void consumePdbxReferenceEntityLink(PdbxReferenceEntityLink pdbxReferenceEntityLink) {
    }

    @Override
    public void consumePdbxReferenceEntityList(PdbxReferenceEntityList pdbxReferenceEntityList) {
    }

    @Override
    public void consumePdbxReferenceEntityPolyLink(PdbxReferenceEntityPolyLink pdbxReferenceEntityPolyLink) {
    }

    @Override
    public void consumePdbxStructAssembly(org.rcsb.cif.model.generated.PdbxStructAssembly pdbxStructAssembly) {
        this.structAssembly = pdbxStructAssembly;
    }

    @Override
    public void consumePdbxStructAssemblyGen(org.rcsb.cif.model.generated.PdbxStructAssemblyGen pdbxStructAssemblyGen) {
        this.structAssemblyGen = pdbxStructAssemblyGen;
    }

    @Override
    public void consumePdbxStructModResidue(PdbxStructModResidue pdbxStructModResidue) {
    }

    @Override
    public void consumePdbxStructOperList(PdbxStructOperList pdbxStructOperList) {
        this.structOpers = pdbxStructOperList;
    }

    @Override
    public void consumeRefine(Refine refine) {
        for (int rowIndex = 0; rowIndex < refine.getRowCount(); ++rowIndex) {
            double lsDResHigh = refine.getLsDResHigh().get(rowIndex);
            if (this.pdbHeader.getResolution() != 99.0f) {
                logger.warn("More than 1 resolution value present, will use last one {} and discard previous {}", (Object)lsDResHigh, (Object)String.format("%4.2f", Float.valueOf(this.pdbHeader.getResolution())));
            }
            this.pdbHeader.setResolution((float)lsDResHigh);
            FloatColumn lsRFactorRFree = refine.getLsRFactorRFree();
            if (this.pdbHeader.getRfree() != 1.0f) {
                logger.warn("More than 1 Rfree value present, will use last one {} and discard previous {}", (Object)lsRFactorRFree, (Object)String.format("%4.2f", Float.valueOf(this.pdbHeader.getRfree())));
            }
            if (lsRFactorRFree.isDefined()) {
                this.pdbHeader.setRfree((float)lsRFactorRFree.get(rowIndex));
            } else {
                logger.info("_refine.ls_R_factor_R_free not present, not parsing Rfree value");
            }
            FloatColumn lsRFactorRWork = refine.getLsRFactorRWork();
            if (this.pdbHeader.getRwork() != 1.0f) {
                logger.warn("More than 1 R work value present, will use last one {} and discard previous {} ", (Object)lsRFactorRWork, (Object)String.format("%4.2f", Float.valueOf(this.pdbHeader.getRwork())));
            }
            if (lsRFactorRWork.isDefined()) {
                this.pdbHeader.setRwork((float)lsRFactorRWork.get(rowIndex));
                continue;
            }
            logger.info("_refine.ls_R_factor_R_work not present, not parsing R-work value");
        }
    }

    @Override
    public void consumeStruct(Struct struct) {
        if (struct.isDefined() && struct.getTitle().isDefined()) {
            this.pdbHeader.setTitle(struct.getTitle().get(0));
        }
        if (struct.isDefined() && struct.getEntryId().isDefined()) {
            this.pdbHeader.setIdCode(struct.getEntryId().get(0));
            this.structure.setPDBCode(struct.getEntryId().get(0));
        }
    }

    @Override
    public void consumeStructAsym(StructAsym structAsym) {
        this.structAsym = structAsym;
    }

    @Override
    public void consumeStructConf(StructConf structConf) {
    }

    @Override
    public void consumeStructConn(org.rcsb.cif.model.generated.StructConn structConn) {
        this.structConn = structConn;
    }

    @Override
    public void consumeStructConnType(StructConnType structConnType) {
    }

    @Override
    public void consumeStructKeywords(StructKeywords structKeywords) {
        StrColumn pdbxKeywords = structKeywords.getPdbxKeywords();
        this.pdbHeader.setDescription(pdbxKeywords.values().collect(Collectors.joining(", ")));
        this.pdbHeader.setClassification(pdbxKeywords.values().collect(Collectors.joining(", ")));
    }

    @Override
    public void consumeStructNcsOper(StructNcsOper structNcsOper) {
        this.structNcsOper = structNcsOper;
    }

    @Override
    public void consumeStructRef(StructRef structRef) {
        this.structRef = structRef;
    }

    @Override
    public void consumeStructRefSeq(StructRefSeq structRefSeq) {
        for (int rowIndex = 0; rowIndex < structRefSeq.getRowCount(); ++rowIndex) {
            String pdbxDbAlignEndInsCode;
            String pdbxDbAlignBegInsCode;
            int seqEnd;
            int seqBegin;
            String refId = structRefSeq.getRefId().get(rowIndex);
            DBRef dbRef = new DBRef();
            dbRef.setIdCode(structRefSeq.getPdbxPDBIdCode().get(rowIndex));
            dbRef.setDbAccession(structRefSeq.getPdbxDbAccession().get(rowIndex));
            dbRef.setDbIdCode(structRefSeq.getPdbxDbAccession().get(rowIndex));
            dbRef.setChainName(structRefSeq.getPdbxStrandId().get(rowIndex));
            OptionalInt structRefRowIndex = IntStream.range(0, this.structRef.getRowCount()).filter(i -> this.structRef.getId().get(i).equals(refId)).findFirst();
            if (structRefRowIndex.isPresent()) {
                dbRef.setDatabase(this.structRef.getDbName().get(structRefRowIndex.getAsInt()));
                dbRef.setDbIdCode(this.structRef.getDbCode().get(structRefRowIndex.getAsInt()));
            } else {
                logger.info("could not find StructRef `{} for StructRefSeq {}", (Object)refId, (Object)rowIndex);
            }
            try {
                seqBegin = Integer.parseInt(structRefSeq.getPdbxAuthSeqAlignBeg().get(rowIndex));
                seqEnd = Integer.parseInt(structRefSeq.getPdbxAuthSeqAlignEnd().get(rowIndex));
            }
            catch (NumberFormatException e) {
                logger.warn("Couldn't parse pdbx_auth_seq_align_beg/end in _struct_ref_seq. Will not store dbref alignment info for accession {}. Error: {}", (Object)dbRef.getDbAccession(), (Object)e.getMessage());
                return;
            }
            char beginInsCode = ' ';
            String pdbxSeqAlignBegInsCode = structRefSeq.getPdbxSeqAlignBegInsCode().get(rowIndex);
            if (pdbxSeqAlignBegInsCode.length() > 0) {
                beginInsCode = pdbxSeqAlignBegInsCode.charAt(0);
            }
            char endInsCode = ' ';
            String pdbxSeqAlignEndInsCode = structRefSeq.getPdbxSeqAlignEndInsCode().get(rowIndex);
            if (pdbxSeqAlignEndInsCode.length() > 0) {
                endInsCode = pdbxSeqAlignEndInsCode.charAt(0);
            }
            if (beginInsCode == '?') {
                beginInsCode = ' ';
            }
            if (endInsCode == '?') {
                endInsCode = ' ';
            }
            dbRef.setSeqBegin(seqBegin);
            dbRef.setInsertBegin(beginInsCode);
            dbRef.setSeqEnd(seqEnd);
            dbRef.setInsertEnd(endInsCode);
            int dbSeqBegin = structRefSeq.getDbAlignBeg().get(rowIndex);
            int dbSeqEnd = structRefSeq.getDbAlignEnd().get(rowIndex);
            char dbBeginInsCode = ' ';
            StrColumn pdbxDbAlignBegInsCodeCol = structRefSeq.getPdbxDbAlignBegInsCode();
            if (pdbxDbAlignBegInsCodeCol.isDefined() && (pdbxDbAlignBegInsCode = pdbxDbAlignBegInsCodeCol.get(rowIndex)).length() > 0) {
                dbBeginInsCode = pdbxDbAlignBegInsCode.charAt(0);
            }
            char dbEndInsCode = ' ';
            StrColumn pdbxDbAlignEndInsCodeCol = structRefSeq.getPdbxDbAlignEndInsCode();
            if (pdbxDbAlignEndInsCodeCol.isDefined() && (pdbxDbAlignEndInsCode = pdbxDbAlignEndInsCodeCol.get(rowIndex)).length() > 0) {
                dbEndInsCode = pdbxDbAlignEndInsCode.charAt(0);
            }
            if (dbBeginInsCode == '?') {
                dbBeginInsCode = ' ';
            }
            if (dbEndInsCode == '?') {
                dbEndInsCode = ' ';
            }
            dbRef.setDbSeqBegin(dbSeqBegin);
            dbRef.setIdbnsBegin(dbBeginInsCode);
            dbRef.setDbSeqEnd(dbSeqEnd);
            dbRef.setIdbnsEnd(dbEndInsCode);
            List<DBRef> dbrefs = this.structure.getDBRefs();
            if (dbrefs == null) {
                dbrefs = new ArrayList<DBRef>();
            }
            dbrefs.add(dbRef);
            logger.debug(dbRef.toPDB());
            this.structure.setDBRefs(dbrefs);
        }
    }

    @Override
    public void consumeStructRefSeqDif(StructRefSeqDif structRefSeqDif) {
        this.structRefSeqDif = structRefSeqDif;
    }

    @Override
    public void consumeStructSheetRange(StructSheetRange structSheetRange) {
    }

    @Override
    public void consumeStructSite(StructSite structSite) {
        if (this.params.isHeaderOnly()) {
            return;
        }
        List<Site> sites = this.structure.getSites();
        if (sites == null) {
            sites = new ArrayList<Site>();
        }
        for (int rowIndex = 0; rowIndex < structSite.getRowCount(); ++rowIndex) {
            Site site = null;
            for (Site asite : sites) {
                if (!asite.getSiteID().equals(structSite.getId().get(rowIndex))) continue;
                site = asite;
            }
            boolean addSite = false;
            if (site == null) {
                site = new Site();
                addSite = true;
            }
            site.setSiteID(structSite.getId().get(rowIndex));
            site.setDescription(structSite.getDetails().get(rowIndex));
            site.setEvCode(structSite.getPdbxEvidenceCode().get(rowIndex));
            if (!addSite) continue;
            sites.add(site);
        }
        this.structure.setSites(sites);
    }

    @Override
    public void consumeStructSiteGen(StructSiteGen structSiteGen) {
        this.structSiteGen = structSiteGen;
    }

    @Override
    public void consumeSymmetry(Symmetry symmetry) {
        for (int rowIndex = 0; rowIndex < symmetry.getRowCount(); ++rowIndex) {
            String spaceGroupString = symmetry.getSpaceGroupNameH_M().get(rowIndex);
            SpaceGroup spaceGroup = SymoplibParser.getSpaceGroup(spaceGroupString);
            if (spaceGroup == null) {
                logger.warn("Space group '{}' not recognised as a standard space group", (Object)spaceGroupString);
                this.structure.getPDBHeader().getCrystallographicInfo().setNonStandardSg(true);
                continue;
            }
            this.structure.getPDBHeader().getCrystallographicInfo().setSpaceGroup(spaceGroup);
            this.structure.getPDBHeader().getCrystallographicInfo().setNonStandardSg(false);
        }
    }

    @Override
    public void finish() {
        Object chain2;
        if (this.currentChain != null) {
            this.currentChain.addGroup(this.currentGroup);
            Optional<Chain> testChain = this.currentModel.stream().filter(chain -> chain.getId().equals(this.currentChain.getId())).findFirst();
            if (!testChain.isPresent()) {
                this.currentModel.add(this.currentChain);
            }
        } else if (!this.params.isHeaderOnly()) {
            logger.warn("current chain is null at end of document.");
        }
        this.allModels.add(this.currentModel);
        this.initMaps();
        for (int rowIndex = 0; rowIndex < this.structAsym.getRowCount(); ++rowIndex) {
            String id = this.structAsym.getId().get(rowIndex);
            String entityId = this.structAsym.getEntityId().get(rowIndex);
            logger.debug("Entity {} matches asym_id: {}", (Object)entityId, (Object)id);
            chain2 = this.getEntityChain(entityId);
            Chain seqRes = (Chain)chain2.clone();
            seqRes = CifFileConsumerImpl.removeSeqResHeterogeneity(seqRes);
            seqRes.setId(id);
            seqRes.setName(this.asymId2authorId.getOrDefault(id, id));
            EntityType type = EntityType.entityTypeFromString(this.getEntityType(entityId));
            if (type == null || type == EntityType.POLYMER) {
                this.seqResChains.add(seqRes);
            }
            logger.debug(" seqres: {} {}<", (Object)id, (Object)seqRes);
            this.addEntity(rowIndex, entityId, this.getEntityDescription(entityId), this.getEntityType(entityId));
        }
        if (!this.structAsym.isDefined() || this.structAsym.getRowCount() == 0) {
            logger.warn("No _struct_asym category in file, no SEQRES groups will be added.");
        }
        this.linkEntities();
        this.allModels.forEach(this.structure::addModel);
        if (this.params.isAlignSeqRes() && !this.params.isHeaderOnly()) {
            logger.debug("Parsing mode align_seqres, will parse SEQRES and align to ATOM sequence");
            this.alignSeqRes();
        } else {
            logger.debug("Parsing mode unalign_seqres, will parse SEQRES but not align it to ATOM sequence");
            SeqRes2AtomAligner.storeUnAlignedSeqRes(this.structure, this.seqResChains, this.params.isHeaderOnly());
        }
        StructureTools.cleanUpAltLocs(this.structure);
        if (!this.params.isHeaderOnly()) {
            if (this.params.shouldCreateAtomBonds()) {
                this.addBonds();
            }
            if (this.params.shouldCreateAtomCharges()) {
                this.addCharges();
            }
        }
        if (!this.params.isHeaderOnly()) {
            this.addSites();
        }
        if (this.params.isParseBioAssembly()) {
            LinkedHashMap<Integer, BioAssemblyInfo> bioAssemblies = new LinkedHashMap<Integer, BioAssemblyInfo>();
            List<PdbxStructAssembly> structAssemblies = this.convert(this.structAssembly);
            List<PdbxStructAssemblyGen> structAssemblyGens = this.convert(this.structAssemblyGen);
            for (PdbxStructAssembly pdbxStructAssembly : structAssemblies) {
                List<PdbxStructAssemblyGen> pdbxStructAssemblyGens = structAssemblyGens.stream().filter(sag -> sag.getAssembly_id().equals(pdbxStructAssembly.getId())).collect(Collectors.toList());
                BiologicalAssemblyBuilder builder = new BiologicalAssemblyBuilder();
                ArrayList<BiologicalAssemblyTransformation> transformations = builder.getBioUnitTransformationList(pdbxStructAssembly, pdbxStructAssemblyGens, this.convert(this.structOpers));
                int bioAssemblyId = -1;
                try {
                    bioAssemblyId = Integer.parseInt(pdbxStructAssembly.getId());
                }
                catch (NumberFormatException e) {
                    logger.info("Could not parse a numerical bio assembly id from '{}'", (Object)pdbxStructAssembly.getId());
                }
                if (bioAssemblyId == -1) continue;
                int mmSize = 0;
                for (BiologicalAssemblyTransformation transf : transformations) {
                    Chain c = this.structure.getChain(transf.getChainId());
                    if (c == null) {
                        logger.info("Could not find asym id {} specified in struct_assembly_gen", (Object)transf.getChainId());
                        continue;
                    }
                    if (c.getEntityType() != EntityType.POLYMER || c.getEntityInfo().getDescription().contains("SUGAR")) continue;
                    ++mmSize;
                }
                BioAssemblyInfo bioAssembly = new BioAssemblyInfo();
                bioAssembly.setId(bioAssemblyId);
                bioAssembly.setMacromolecularSize(mmSize);
                bioAssembly.setTransforms(transformations);
                bioAssemblies.put(bioAssemblyId, bioAssembly);
            }
            this.structure.getPDBHeader().setBioAssemblies(bioAssemblies);
        }
        this.setStructNcsOps();
        this.setCrystallographicInfoMetadata();
        HashMap<String, List> misMatchMap = new HashMap<String, List>();
        for (int rowIndex = 0; rowIndex < this.structRefSeqDif.getRowCount(); ++rowIndex) {
            SeqMisMatchImpl seqMisMatch = new SeqMisMatchImpl();
            seqMisMatch.setDetails(this.structRefSeqDif.getDetails().get(rowIndex));
            String insCode = this.structRefSeqDif.getPdbxPdbInsCode().get(rowIndex);
            if (insCode != null && insCode.equals("?")) {
                insCode = null;
            }
            seqMisMatch.setInsCode(insCode);
            seqMisMatch.setOrigGroup(this.structRefSeqDif.getDbMonId().get(rowIndex));
            seqMisMatch.setPdbGroup(this.structRefSeqDif.getMonId().get(rowIndex));
            seqMisMatch.setPdbResNum(this.structRefSeqDif.getPdbxAuthSeqNum().get(rowIndex));
            seqMisMatch.setUniProtId(this.structRefSeqDif.getPdbxSeqDbAccessionCode().get(rowIndex));
            seqMisMatch.setSeqNum(this.structRefSeqDif.getSeqNum().get(rowIndex));
            String strandId = this.structRefSeqDif.getPdbxPdbStrandId().get(rowIndex);
            List seqMisMatches = misMatchMap.computeIfAbsent(strandId, k -> new ArrayList());
            seqMisMatches.add(seqMisMatch);
        }
        for (String chainId : misMatchMap.keySet()) {
            chain2 = this.structure.getPolyChainByPDB(chainId);
            if (chain2 == null) {
                logger.warn("Could not set mismatches for chain with author id {}", (Object)chainId);
                continue;
            }
            chain2.setSeqMisMatches((List)misMatchMap.get(chainId));
        }
    }

    private String getEntityType(String entityId) {
        return IntStream.range(0, this.entity.getRowCount()).filter(i -> this.entity.getId().get(i).equals(entityId)).mapToObj(i -> this.entity.getType().get(i)).findFirst().orElseThrow(() -> new NoSuchElementException("could not find entity with id " + entityId));
    }

    private String getEntityDescription(String entityId) {
        return IntStream.range(0, this.entity.getRowCount()).filter(i -> this.entity.getId().get(i).equals(entityId)).mapToObj(i -> this.entity.getPdbxDescription().get(i)).findFirst().orElseThrow(() -> new NoSuchElementException("could not find entity with id " + entityId));
    }

    private void addEntity(int asymRowIndex, String entityId, String pdbxDescription, String type) {
        int eId = 0;
        try {
            eId = Integer.parseInt(entityId);
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse mol_id from string {}. Will use 0 for creating Entity", (Object)entityId);
        }
        int entityRowIndex = IntStream.range(0, this.entity.getRowCount()).filter(i -> this.entity.getId().get(i).equals(entityId)).findFirst().orElse(-1);
        EntityInfo entityInfo = this.structure.getEntityById(eId);
        if (entityInfo == null) {
            entityInfo = new EntityInfo();
            entityInfo.setMolId(eId);
            if (entityRowIndex != -1) {
                entityInfo.setDescription(pdbxDescription);
                EntityType eType = EntityType.entityTypeFromString(type);
                if (eType != null) {
                    entityInfo.setType(eType);
                } else {
                    logger.warn("Type '{}' is not recognised as a valid entity type for entity {}", (Object)type, (Object)eId);
                }
                this.addAncilliaryEntityData(asymRowIndex, entityInfo);
                this.structure.addEntityInfo(entityInfo);
                logger.debug("Adding Entity with entity id {} from _entity, with name: {}", (Object)eId, (Object)entityInfo.getDescription());
            }
        }
    }

    private void addAncilliaryEntityData(int asymRowIndex, EntityInfo entityInfo) {
        int rowIndex;
        for (rowIndex = 0; rowIndex < this.entitySrcGen.getRowCount(); ++rowIndex) {
            if (this.entitySrcGen.getEntityId().get(rowIndex).equals(this.structAsym.getEntityId().get(asymRowIndex))) continue;
            this.addInformationFromEntitySrcGen(rowIndex, entityInfo);
        }
        for (rowIndex = 0; rowIndex < this.entitySrcNat.getRowCount(); ++rowIndex) {
            if (this.entitySrcNat.getEntityId().get(rowIndex).equals(this.structAsym.getEntityId().get(asymRowIndex))) continue;
            this.addInformationFromEntitySrcNat(rowIndex, entityInfo);
        }
        for (rowIndex = 0; rowIndex < this.entitySrcSyn.getRowCount(); ++rowIndex) {
            if (this.entitySrcSyn.getEntityId().get(rowIndex).equals(this.structAsym.getEntityId().get(asymRowIndex))) continue;
            this.addInformationFromEntitySrcSyn(rowIndex, entityInfo);
        }
    }

    private void addInformationFromEntitySrcSyn(int rowIndex, EntityInfo entityInfo) {
        entityInfo.setOrganismCommon(this.entitySrcSyn.getOrganismCommonName().get(rowIndex));
        entityInfo.setOrganismScientific(this.entitySrcSyn.getOrganismScientific().get(rowIndex));
        entityInfo.setOrganismTaxId(this.entitySrcSyn.getNcbiTaxonomyId().get(rowIndex));
    }

    private void addInformationFromEntitySrcNat(int rowIndex, EntityInfo entityInfo) {
        entityInfo.setAtcc(this.entitySrcNat.getPdbxAtcc().get(rowIndex));
        entityInfo.setCell(this.entitySrcNat.getPdbxCell().get(rowIndex));
        entityInfo.setOrganismCommon(this.entitySrcNat.getCommonName().get(rowIndex));
        entityInfo.setOrganismScientific(this.entitySrcNat.getPdbxOrganismScientific().get(rowIndex));
        entityInfo.setOrganismTaxId(this.entitySrcNat.getPdbxNcbiTaxonomyId().get(rowIndex));
    }

    private void addInformationFromEntitySrcGen(int rowIndex, EntityInfo entityInfo) {
        entityInfo.setAtcc(this.entitySrcGen.getPdbxGeneSrcAtcc().get(rowIndex));
        entityInfo.setCell(this.entitySrcGen.getPdbxGeneSrcCell().get(rowIndex));
        entityInfo.setOrganismCommon(this.entitySrcGen.getGeneSrcCommonName().get(rowIndex));
        entityInfo.setOrganismScientific(this.entitySrcGen.getPdbxGeneSrcScientificName().get(rowIndex));
        entityInfo.setOrganismTaxId(this.entitySrcGen.getPdbxGeneSrcNcbiTaxonomyId().get(rowIndex));
        entityInfo.setExpressionSystemTaxId(this.entitySrcGen.getPdbxHostOrgNcbiTaxonomyId().get(rowIndex));
        entityInfo.setExpressionSystem(this.entitySrcGen.getPdbxHostOrgScientificName().get(rowIndex));
    }

    private void setStructNcsOps() {
        ArrayList<Matrix4d> ncsOperators = new ArrayList<Matrix4d>();
        for (int rowIndex = 0; rowIndex < this.structNcsOper.getRowCount(); ++rowIndex) {
            if (!"generate".equals(this.structNcsOper.getCode().get(rowIndex))) continue;
            try {
                Matrix4d operator = new Matrix4d();
                operator.setElement(0, 0, this.structNcsOper.getMatrix11().get(rowIndex));
                operator.setElement(0, 1, this.structNcsOper.getMatrix12().get(rowIndex));
                operator.setElement(0, 2, this.structNcsOper.getMatrix13().get(rowIndex));
                operator.setElement(1, 0, this.structNcsOper.getMatrix21().get(rowIndex));
                operator.setElement(1, 1, this.structNcsOper.getMatrix22().get(rowIndex));
                operator.setElement(1, 2, this.structNcsOper.getMatrix23().get(rowIndex));
                operator.setElement(2, 0, this.structNcsOper.getMatrix31().get(rowIndex));
                operator.setElement(2, 1, this.structNcsOper.getMatrix32().get(rowIndex));
                operator.setElement(2, 2, this.structNcsOper.getMatrix33().get(rowIndex));
                operator.setElement(3, 0, 0.0);
                operator.setElement(3, 1, 0.0);
                operator.setElement(3, 2, 0.0);
                operator.setElement(3, 3, 1.0);
                ncsOperators.add(operator);
                continue;
            }
            catch (NumberFormatException e) {
                logger.warn("Error parsing doubles in NCS operator list, skipping operator {}", (Object)(rowIndex + 1));
            }
        }
        if (ncsOperators.size() > 0) {
            this.structure.getCrystallographicInfo().setNcsOperators(ncsOperators.toArray(new Matrix4d[0]));
        }
    }

    private List<org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList> convert(PdbxStructOperList structOpers) {
        ArrayList<org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList> re = new ArrayList<org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList>();
        for (int rowIndex = 0; rowIndex < structOpers.getRowCount(); ++rowIndex) {
            org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList pdbxStructOperList = new org.biojava.nbio.structure.io.mmcif.model.PdbxStructOperList();
            pdbxStructOperList.setId(structOpers.getId().get(rowIndex));
            pdbxStructOperList.setName(structOpers.getName().get(rowIndex));
            pdbxStructOperList.setSymmetry_operation(structOpers.getSymmetryOperation().get(rowIndex));
            pdbxStructOperList.setType(structOpers.getType().get(rowIndex));
            pdbxStructOperList.setMatrix11(String.valueOf(structOpers.getMatrix11().get(rowIndex)));
            pdbxStructOperList.setMatrix12(String.valueOf(structOpers.getMatrix12().get(rowIndex)));
            pdbxStructOperList.setMatrix13(String.valueOf(structOpers.getMatrix13().get(rowIndex)));
            pdbxStructOperList.setMatrix21(String.valueOf(structOpers.getMatrix21().get(rowIndex)));
            pdbxStructOperList.setMatrix22(String.valueOf(structOpers.getMatrix22().get(rowIndex)));
            pdbxStructOperList.setMatrix23(String.valueOf(structOpers.getMatrix23().get(rowIndex)));
            pdbxStructOperList.setMatrix31(String.valueOf(structOpers.getMatrix31().get(rowIndex)));
            pdbxStructOperList.setMatrix32(String.valueOf(structOpers.getMatrix32().get(rowIndex)));
            pdbxStructOperList.setMatrix33(String.valueOf(structOpers.getMatrix33().get(rowIndex)));
            pdbxStructOperList.setVector1(String.valueOf(structOpers.getVector1().get(rowIndex)));
            pdbxStructOperList.setVector2(String.valueOf(structOpers.getVector2().get(rowIndex)));
            pdbxStructOperList.setVector3(String.valueOf(structOpers.getVector3().get(rowIndex)));
            re.add(pdbxStructOperList);
        }
        return re;
    }

    private List<PdbxStructAssemblyGen> convert(org.rcsb.cif.model.generated.PdbxStructAssemblyGen structAssemblyGen) {
        ArrayList<PdbxStructAssemblyGen> re = new ArrayList<PdbxStructAssemblyGen>();
        for (int rowIndex = 0; rowIndex < structAssemblyGen.getRowCount(); ++rowIndex) {
            PdbxStructAssemblyGen pdbxStructAssemblyGen = new PdbxStructAssemblyGen();
            pdbxStructAssemblyGen.setAssembly_id(structAssemblyGen.getAssemblyId().get(rowIndex));
            pdbxStructAssemblyGen.setAsym_id_list(structAssemblyGen.getAsymIdList().get(rowIndex));
            pdbxStructAssemblyGen.setOper_expression(structAssemblyGen.getOperExpression().get(rowIndex));
            re.add(pdbxStructAssemblyGen);
        }
        return re;
    }

    private List<PdbxStructAssembly> convert(org.rcsb.cif.model.generated.PdbxStructAssembly structAssembly) {
        ArrayList<PdbxStructAssembly> re = new ArrayList<PdbxStructAssembly>();
        for (int rowIndex = 0; rowIndex < structAssembly.getRowCount(); ++rowIndex) {
            PdbxStructAssembly pdbxStructAssembly = new PdbxStructAssembly();
            pdbxStructAssembly.setDetails(structAssembly.getDetails().get(rowIndex));
            pdbxStructAssembly.setId(structAssembly.getId().get(rowIndex));
            pdbxStructAssembly.setMethod_details(structAssembly.getMethodDetails().get(rowIndex));
            pdbxStructAssembly.setOligomeric_count(structAssembly.getOligomericCount().getStringData(rowIndex));
            pdbxStructAssembly.setOligomeric_details(structAssembly.getOligomericDetails().get(rowIndex));
            re.add(pdbxStructAssembly);
        }
        return re;
    }

    private void setCrystallographicInfoMetadata() {
        if (this.parsedScaleMatrix != null) {
            PDBCrystallographicInfo crystalInfo = this.structure.getCrystallographicInfo();
            boolean nonStd = false;
            if (crystalInfo.getCrystalCell() != null && !crystalInfo.getCrystalCell().checkScaleMatrix(this.parsedScaleMatrix)) {
                nonStd = true;
            }
            crystalInfo.setNonStandardCoordFrameConvention(nonStd);
        }
    }

    private void addSites() {
        List<Site> sites = this.structure.getSites();
        if (sites == null) {
            sites = new ArrayList<Site>();
        }
        for (int rowIndex = 0; rowIndex < this.structSiteGen.getRowCount(); ++rowIndex) {
            List<Group> groups;
            String site_id = this.structSiteGen.getSiteId().get(rowIndex);
            if (site_id == null) {
                site_id = "";
            }
            String comp_id = this.structSiteGen.getLabelCompId().get(rowIndex);
            String asymId = this.structSiteGen.getLabelAsymId().get(rowIndex);
            String authId = this.structSiteGen.getAuthAsymId().get(rowIndex);
            String auth_seq_id = this.structSiteGen.getAuthSeqId().get(rowIndex);
            String insCode = this.structSiteGen.getPdbxAuthInsCode().get(rowIndex);
            if (insCode != null && insCode.equals("?")) {
                insCode = null;
            }
            Group g = null;
            try {
                Chain chain = this.structure.getChain(asymId);
                if (null != chain) {
                    try {
                        Character insChar = null;
                        if (null != insCode && insCode.length() > 0) {
                            insChar = Character.valueOf(insCode.charAt(0));
                        }
                        g = chain.getGroupByPDB(new ResidueNumber(null, Integer.parseInt(auth_seq_id), insChar));
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Could not lookup residue : {}{}", (Object)authId, (Object)auth_seq_id);
                    }
                }
            }
            catch (StructureException e) {
                logger.warn("Problem finding residue in site entry {} - {}", (Object)this.structSiteGen.getSiteId().get(rowIndex), (Object)e.getMessage());
            }
            if (g == null) continue;
            Site site = null;
            for (Site asite : sites) {
                if (!site_id.equals(asite.getSiteID())) continue;
                site = asite;
            }
            boolean addSite = false;
            if (site == null) {
                addSite = true;
                site = new Site();
                site.setSiteID(site_id);
            }
            if ((groups = site.getGroups()) == null) {
                groups = new ArrayList<Group>();
            }
            if (!comp_id.equals(g.getPDBName())) {
                logger.warn("comp_id doesn't match the residue at {} {} - skipping", (Object)authId, (Object)auth_seq_id);
            } else {
                groups.add(g);
                site.setGroups(groups);
            }
            if (!addSite) continue;
            sites.add(site);
        }
        this.structure.setSites(sites);
    }

    private void addCharges() {
        ChargeAdder.addCharges(this.structure);
    }

    private static Chain removeSeqResHeterogeneity(Chain c) {
        ChainImpl trimmedChain = new ChainImpl();
        ResidueNumber lastResNum = null;
        for (Group g : c.getAtomGroups()) {
            ResidueNumber currentResNum = new ResidueNumber(g.getResidueNumber().getChainName(), g.getResidueNumber().getSeqNum(), g.getResidueNumber().getInsCode());
            if (lastResNum == null || !lastResNum.equals(currentResNum)) {
                trimmedChain.addGroup(g);
            } else {
                logger.debug("Removing seqres group because it seems to be repeated in entity_poly_seq, most likely has hetero='y': {}", (Object)g);
            }
            lastResNum = currentResNum;
        }
        return trimmedChain;
    }

    private void addBonds() {
        BondMaker maker = new BondMaker(this.structure, this.params);
        maker.makeBonds();
        maker.formBondsFromStructConn(this.convert(this.structConn));
    }

    private List<StructConn> convert(org.rcsb.cif.model.generated.StructConn structConn) {
        return IntStream.range(0, structConn.getRowCount()).mapToObj(rowIndex -> {
            StructConn sc = new StructConn();
            sc.setPdbx_ptnr1_PDB_ins_code(structConn.getPdbxPtnr1PDBInsCode().get(rowIndex));
            sc.setPdbx_ptnr2_PDB_ins_code(structConn.getPdbxPtnr2PDBInsCode().get(rowIndex));
            sc.setPtnr1_auth_seq_id(structConn.getPtnr1AuthSeqId().getStringData(rowIndex));
            sc.setPtnr2_auth_seq_id(structConn.getPtnr2AuthSeqId().getStringData(rowIndex));
            sc.setPtnr1_label_comp_id(structConn.getPtnr1LabelCompId().get(rowIndex));
            sc.setPtnr2_label_comp_id(structConn.getPtnr2LabelCompId().get(rowIndex));
            sc.setPtnr1_label_atom_id(structConn.getPtnr1LabelAtomId().get(rowIndex));
            sc.setPtnr2_label_atom_id(structConn.getPtnr2LabelAtomId().get(rowIndex));
            sc.setPdbx_ptnr1_label_alt_id(structConn.getPdbxPtnr1LabelAltId().get(rowIndex));
            sc.setPdbx_ptnr2_label_alt_id(structConn.getPdbxPtnr2LabelAltId().get(rowIndex));
            sc.setPtnr1_symmetry(structConn.getPtnr1Symmetry().get(rowIndex));
            sc.setPtnr2_symmetry(structConn.getPtnr2Symmetry().get(rowIndex));
            sc.setConn_type_id(structConn.getConnTypeId().get(rowIndex));
            return sc;
        }).collect(Collectors.toList());
    }

    private void alignSeqRes() {
        logger.debug("Parsing mode align_seqres, will align to ATOM to SEQRES sequence");
        for (int model = 0; model < this.structure.nrModels(); ++model) {
            List<Chain> atomList = this.structure.getModel(model);
            for (Chain seqResChain : this.seqResChains) {
                Chain atomChain = SeqRes2AtomAligner.getMatchingAtomRes(seqResChain, atomList, true);
                if (atomChain == null) {
                    logger.info("Could not map SEQRES chain with asym_id={} to any ATOM chain. Most likely there's no observed residues in the chain.", (Object)seqResChain.getId());
                    continue;
                }
                ArrayList<Group> seqResGroups = new ArrayList<Group>();
                for (int i = 0; i < seqResChain.getAtomGroups().size(); ++i) {
                    seqResGroups.add((Group)seqResChain.getAtomGroups().get(i).clone());
                }
                for (int seqResPos = 0; seqResPos < seqResGroups.size(); ++seqResPos) {
                    Group seqresG = (Group)seqResGroups.get(seqResPos);
                    boolean found = false;
                    for (Group atomG : atomChain.getAtomGroups()) {
                        int internalNr = this.getInternalNr(atomG);
                        if (seqresG.getResidueNumber().getSeqNum() != internalNr) continue;
                        seqResGroups.set(seqResPos, atomG);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    seqresG.setResidueNumber(null);
                }
                atomChain.setSeqResGroups(seqResGroups);
            }
        }
    }

    private int getInternalNr(Group atomG) {
        if (atomG.getType().equals((Object)GroupType.AMINOACID)) {
            AminoAcidImpl aa = (AminoAcidImpl)atomG;
            return (int)aa.getId();
        }
        if (atomG.getType().equals((Object)GroupType.NUCLEOTIDE)) {
            NucleotideImpl nu = (NucleotideImpl)atomG;
            return (int)nu.getId();
        }
        HetatomImpl he = (HetatomImpl)atomG;
        return (int)he.getId();
    }

    private void linkEntities() {
        for (List<Chain> allModel : this.allModels) {
            for (Chain chain : allModel) {
                String entityId = this.asymId2entityId.get(chain.getId());
                if (entityId == null) {
                    logger.info("No entity id could be found for chain {}", (Object)chain.getId());
                    continue;
                }
                int eId = Integer.parseInt(entityId);
                EntityInfo entityInfo = this.structure.getEntityById(eId);
                if (entityInfo == null) {
                    logger.info("Could not find an Entity for entity_id {}, for chain id {}, creating a new Entity.", (Object)eId, (Object)chain.getId());
                    entityInfo = new EntityInfo();
                    entityInfo.setMolId(eId);
                    entityInfo.addChain(chain);
                    if (chain.isWaterOnly()) {
                        entityInfo.setType(EntityType.WATER);
                    } else {
                        entityInfo.setType(EntityType.NONPOLYMER);
                    }
                    chain.setEntityInfo(entityInfo);
                    this.structure.addEntityInfo(entityInfo);
                    continue;
                }
                logger.debug("Adding chain with chain id {} (auth id {}) to Entity with entity_id {}", new Object[]{chain.getId(), chain.getName(), eId});
                entityInfo.addChain(chain);
                chain.setEntityInfo(entityInfo);
            }
        }
        List<EntityInfo> entityInfos = this.structure.getEntityInfos();
        if (entityInfos == null || entityInfos.isEmpty()) {
            ArrayList<List<Chain>> polyModels = new ArrayList<List<Chain>>();
            ArrayList<List<Chain>> nonPolyModels = new ArrayList<List<Chain>>();
            ArrayList<List<Chain>> waterModels = new ArrayList<List<Chain>>();
            for (List<Chain> model : this.allModels) {
                ArrayList<Chain> polyChains = new ArrayList<Chain>();
                ArrayList<Chain> nonPolyChains = new ArrayList<Chain>();
                ArrayList<Chain> waterChains = new ArrayList<Chain>();
                polyModels.add(polyChains);
                nonPolyModels.add(nonPolyChains);
                waterModels.add(waterChains);
                for (Chain chain : model) {
                    if (chain.isWaterOnly()) {
                        waterChains.add(chain);
                        continue;
                    }
                    if (chain.isPureNonPolymer()) {
                        nonPolyChains.add(chain);
                        continue;
                    }
                    polyChains.add(chain);
                }
            }
            entityInfos = EntityFinder.findPolyEntities(polyModels);
            EntityFinder.createPurelyNonPolyEntities(nonPolyModels, waterModels, entityInfos);
            this.structure.setEntityInfos(entityInfos);
        }
        for (EntityInfo e : entityInfos) {
            if (!e.getChains().isEmpty()) continue;
            logger.info("Entity {} '{}' has no chains associated to it", e.getMolId() < 0 ? "with no entity id" : Integer.valueOf(e.getMolId()), (Object)e.getDescription());
        }
    }

    private void initMaps() {
        int rowIndex;
        if (this.structAsym == null || !this.structAsym.isDefined() || this.structAsym.getRowCount() == 0) {
            logger.info("No _struct_asym category found in file. No asym id to entity_id mapping will be available");
            return;
        }
        HashMap entityId2asymId = new HashMap();
        for (rowIndex = 0; rowIndex < this.structAsym.getRowCount(); ++rowIndex) {
            List<String> asymIds;
            String id = this.structAsym.getId().get(rowIndex);
            String entityId = this.structAsym.getEntityId().get(rowIndex);
            logger.debug("Entity {} matches asym_id: {}", (Object)entityId, (Object)id);
            this.asymId2entityId.put(id, entityId);
            if (entityId2asymId.containsKey(entityId)) {
                asymIds = (List)entityId2asymId.get(entityId);
                asymIds.add(id);
                continue;
            }
            asymIds = new ArrayList();
            asymIds.add(id);
            entityId2asymId.put(entityId, asymIds);
        }
        if (this.entityPoly == null || !this.entityPoly.isDefined() || this.entityPoly.getRowCount() == 0) {
            logger.info("No _entity_poly category found in file. No asym id to author id mapping will be available for header only parsing");
            return;
        }
        for (rowIndex = 0; rowIndex < this.entityPoly.getRowCount(); ++rowIndex) {
            List asymIds;
            if (!this.entityPoly.getPdbxStrandId().isDefined()) {
                logger.info("_entity_poly.pdbx_strand_id is null for entity {}. Won't be able to map asym ids to author ids for this entity.", (Object)this.entityPoly.getEntityId().get(rowIndex));
                break;
            }
            String[] chainNames = this.entityPoly.getPdbxStrandId().get(rowIndex).split(",");
            if (chainNames.length != (asymIds = (List)entityId2asymId.get(this.entityPoly.getEntityId().get(rowIndex))).size()) {
                logger.warn("The list of asym ids (from _struct_asym) and the list of author ids (from _entity_poly) for entity {} have different lengths! Can't provide a mapping from asym ids to author chain ids", (Object)this.entityPoly.getEntityId().get(rowIndex));
                break;
            }
            for (int i = 0; i < chainNames.length; ++i) {
                this.asymId2authorId.put((String)asymIds.get(i), chainNames[i]);
            }
        }
    }

    @Override
    public Structure getContainer() {
        return this.structure;
    }
}

