/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.geometry;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.geometry.CalcPoint;
import org.biojava.nbio.structure.geometry.SuperPosition;

public abstract class SuperPositionAbstract
implements SuperPosition {
    protected boolean centered;

    public SuperPositionAbstract(boolean centered) {
        this.centered = centered;
    }

    @Override
    public Matrix4d superposeAndTransform(Point3d[] fixed, Point3d[] moved) {
        Matrix4d rotTrans = this.superpose(fixed, moved);
        CalcPoint.transform(rotTrans, moved);
        return rotTrans;
    }

    protected void checkInput(Point3d[] fixed, Point3d[] moved) {
        if (fixed.length != moved.length) {
            throw new IllegalArgumentException("Point arrays to superpose are of different lengths.");
        }
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }
}

