/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology.obo;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.ontology.AlreadyExistsException;
import org.biojava.nbio.ontology.Ontology;
import org.biojava.nbio.ontology.Synonym;
import org.biojava.nbio.ontology.Term;
import org.biojava.nbio.ontology.obo.OboFileEventListener;
import org.biojava.nbio.ontology.utils.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboFileHandler
implements OboFileEventListener {
    private static final Logger logger = LoggerFactory.getLogger(OboFileEventListener.class);
    Ontology ontology;
    List<Term> termStack;
    public static final String TERM = "Term";
    public static final String TYPEDEF = "Typedef";
    public static final String ONTOLOGY = "ontologys";
    public static final String ID_KEY = "id";
    public static final String SYNONYM = "synonym";
    public static final String EXACT_SYNONYM = "exact_synonym";
    public static final String BROAD_SYNONYM = "broad_synonym";
    public static final String NARROW_SYNONYM = "narrow_synonym";
    public static final String REL_SYNONYM = "related_synonym";
    public static final String NAME = "name";
    public static final String DEF = "def";
    public static final String XREF_ANALOG = "xref_analog";
    public static final String COMMENT = "comment";
    public static final String IS_A = "is_a";
    public static final String IS_OBSOLETE = "is_obsolete";
    public static final String RELATIONSHIP = "relationship";
    public static final String DISJOINT_FROM = "disjoint_from";
    public static final String SUBSET = "subset";
    public static final String INTERSECTION_OF = "intersection_of";
    public static final String ALT_ID = "alt_id";
    boolean isTerm;
    private Term currentTerm;

    public OboFileHandler(Ontology ontology) {
        this.ontology = ontology;
    }

    @Override
    public void documentEnd() {
    }

    @Override
    public void documentStart() {
        this.termStack = new ArrayList<Term>();
    }

    @Override
    public void newOboFileHeader() {
    }

    @Override
    public void newStanza(String stanza) {
        if (stanza.equals(TERM)) {
            this.isTerm = true;
            this.currentTerm = null;
        } else {
            this.isTerm = false;
        }
    }

    @Override
    public void newKey(String key, String value) {
        if (this.isTerm) {
            if (key.equals(ID_KEY)) {
                if (this.ontology.containsTerm(key)) {
                    this.currentTerm = this.ontology.getTerm(key);
                } else {
                    try {
                        this.currentTerm = this.ontology.containsTerm(value) ? this.ontology.getTerm(value) : this.ontology.createTerm(value);
                    }
                    catch (AlreadyExistsException ex) {
                        logger.error("Exception: ", (Throwable)ex);
                    }
                }
                return;
            }
            if (this.currentTerm == null) {
                logger.warn("did not find ID for Term! ");
                return;
            }
            if (key.equals(NAME)) {
                this.currentTerm.setDescription(value);
            } else if (key.equals(DEF)) {
                Annotation anno = this.currentTerm.getAnnotation();
                anno.setProperty(DEF, value);
            } else if (key.equals(XREF_ANALOG)) {
                Annotation anno = this.currentTerm.getAnnotation();
                anno.setProperty(XREF_ANALOG, value);
            } else if (key.equals(IS_OBSOLETE)) {
                Annotation anno = this.currentTerm.getAnnotation();
                anno.setProperty(IS_OBSOLETE, new Boolean(true));
            } else if (key.equals(IS_A) || key.equals(RELATIONSHIP) || key.equals(DISJOINT_FROM) || key.equals(INTERSECTION_OF) || key.equals(SUBSET)) {
                try {
                    Term object = this.ontology.containsTerm(value) ? this.ontology.getTerm(value) : this.ontology.createTerm(value);
                    Term predicate = this.ontology.containsTerm(key) ? this.ontology.getTerm(key) : this.ontology.createTerm(key);
                    this.ontology.createTriple(this.currentTerm, object, predicate, this.currentTerm + " " + predicate + " " + object, key + "-relationship");
                }
                catch (AlreadyExistsException object) {}
            } else if (key.equals(COMMENT)) {
                Annotation anno = this.currentTerm.getAnnotation();
                anno.setProperty(COMMENT, value);
            } else if (key.equals(ALT_ID)) {
                Annotation anno = this.currentTerm.getAnnotation();
                anno.setProperty(ALT_ID, value);
            }
        }
    }

    @Override
    public void newSynonym(Synonym synonym) {
        if (this.isTerm) {
            this.currentTerm.addSynonym(synonym);
        }
    }
}

