/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.om.OMNamespace;

public class NamespaceImpl
implements OMNamespace {
    private final String nsUri;
    private final String nsPrefix;

    public NamespaceImpl(String uri) {
        this(uri, null);
    }

    public NamespaceImpl(String uri, String prefix) {
        if (uri == null) {
            throw new IllegalArgumentException("Namespace URI may not be null");
        }
        this.nsUri = uri;
        this.nsPrefix = prefix;
    }

    public boolean equals(String uri, String prefix) {
        return this.nsUri.equals(uri) && (this.nsPrefix == null ? prefix == null : this.nsPrefix.equals(prefix));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OMNamespace)) {
            return false;
        }
        OMNamespace other = (OMNamespace)obj;
        String otherPrefix = other.getPrefix();
        return this.nsUri.equals(other.getNamespaceURI()) && (this.nsPrefix == null ? otherPrefix == null : this.nsPrefix.equals(otherPrefix));
    }

    public String getPrefix() {
        return this.nsPrefix;
    }

    public String getName() {
        return this.nsUri;
    }

    public String getNamespaceURI() {
        return this.nsUri;
    }

    public int hashCode() {
        return this.nsUri.hashCode() ^ (this.nsPrefix != null ? this.nsPrefix.hashCode() : 0);
    }
}

