/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundRequestMapper
implements ICompoundRequestMapper {
    private final List<IRequestMapper> mappers = new CopyOnWriteArrayList<IRequestMapper>();

    @Override
    public CompoundRequestMapper add(IRequestMapper mapper) {
        this.mappers.add(0, mapper);
        return this;
    }

    @Override
    public CompoundRequestMapper remove(IRequestMapper mapper) {
        this.mappers.remove(mapper);
        return this;
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        ArrayList<MapperWithScore> list = new ArrayList<MapperWithScore>(this.mappers.size());
        for (IRequestMapper mapper : this.mappers) {
            int score = mapper.getCompatibilityScore(request);
            list.add(new MapperWithScore(mapper, score));
        }
        Collections.sort(list);
        for (MapperWithScore mapperWithScore : list) {
            IRequestHandler handler = mapperWithScore.getMapper().mapRequest(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Override
    public Url mapHandler(IRequestHandler handler) {
        for (IRequestMapper mapper : this.mappers) {
            Url url = mapper.mapHandler(handler);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = Integer.MIN_VALUE;
        for (IRequestMapper mapper : this.mappers) {
            score = Math.max(score, mapper.getCompatibilityScore(request));
        }
        return score;
    }

    @Override
    public Iterator<IRequestMapper> iterator() {
        return this.mappers.iterator();
    }

    @Override
    public void unmount(String path) {
        Url url = Url.parse(path);
        Request request = this.createRequest(url);
        for (IRequestMapper mapper : this) {
            if (mapper.mapRequest(request) == null) continue;
            this.remove(mapper);
        }
    }

    int size() {
        return this.mappers.size();
    }

    Request createRequest(final Url url) {
        Request request = new Request(){

            public Url getUrl() {
                return url;
            }

            public Locale getLocale() {
                return null;
            }

            public Object getContainerRequest() {
                return null;
            }

            public Url getClientUrl() {
                return null;
            }

            public Charset getCharset() {
                return null;
            }
        };
        return request;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapperWithScore
    implements Comparable<MapperWithScore> {
        private final IRequestMapper mapper;
        private final int compatibilityScore;

        public MapperWithScore(IRequestMapper mapper, int compatibilityScore) {
            this.mapper = mapper;
            this.compatibilityScore = compatibilityScore;
        }

        @Override
        public int compareTo(MapperWithScore o) {
            return o.compatibilityScore - this.compatibilityScore;
        }

        public IRequestMapper getMapper() {
            return this.mapper;
        }

        public String toString() {
            return "Mapper: " + this.mapper.getClass().getName() + "; Score: " + this.compatibilityScore;
        }
    }
}

