/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.console;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlFormBuilder {
    public String build(DataForm form) {
        if (form == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator instructions = form.getInstructions();
        while (instructions.hasNext()) {
            sb.append("<p class='instruction'>" + (String)instructions.next() + "</p>");
        }
        Iterator fields = form.getFields();
        while (fields.hasNext()) {
            FormField field = (FormField)fields.next();
            String type = field.getType();
            sb.append("<p>");
            if ("hidden".equals(type)) {
                sb.append(this.hiddenFieldToHtml(field));
            } else if ("fixed".equals(type)) {
                sb.append(this.fixedFieldToHtml(field));
            } else if ("jid-single".equals(type)) {
                sb.append(this.jidSingleFieldToHtml(field));
            } else if ("text-single".equals(type) || type == null) {
                sb.append(this.textSingleFieldToHtml(field));
            } else if ("text-private".equals(type)) {
                sb.append(this.textPrivateFieldToHtml(field));
            } else if ("text-multi".equals(type)) {
                sb.append(this.textMultiFieldToHtml(field));
            } else if ("list-single".equals(type)) {
                sb.append(this.listSingleFieldToHtml(field));
            } else if ("list-multi".equals(type)) {
                sb.append(this.listMultiFieldToHtml(field));
            } else if ("jid-multi".equals(type)) {
                sb.append(this.textMultiFieldToHtml(field));
            } else if ("boolean".equals(type)) {
                sb.append(this.booleanFieldToHtml(field));
            } else {
                throw new RuntimeException("Unknown field type: " + type);
            }
            sb.append(this.descToHtml(field));
            sb.append("</p>");
        }
        return sb.toString();
    }

    private String labelToHtml(FormField field) {
        StringBuilder sb = new StringBuilder();
        if (field.getLabel() != null) {
            sb.append("<label for='");
            sb.append(this.varToId(field.getVariable()));
            sb.append("'>");
            sb.append(field.getLabel());
            sb.append("</label>");
        }
        return sb.toString();
    }

    private String descToHtml(FormField field) {
        StringBuilder sb = new StringBuilder();
        if (field.getDescription() != null) {
            sb.append("<img src='resources/info.png' title='");
            sb.append(field.getDescription());
            sb.append("' />");
        }
        return sb.toString();
    }

    private String fixedFieldToHtml(FormField field) {
        StringBuilder sb = new StringBuilder();
        if (field.getLabel() != null) {
            sb.append(field.getLabel());
        }
        sb.append(" <span>" + (String)field.getValues().next() + "</span>");
        return sb.toString();
    }

    private String hiddenFieldToHtml(FormField field) {
        return this.singleValueFieldToHtml(field, "hidden", null);
    }

    private String jidSingleFieldToHtml(FormField field) {
        return this.singleValueFieldToHtml(field, "email", "example@vysper.org");
    }

    private String textSingleFieldToHtml(FormField field) {
        return this.singleValueFieldToHtml(field, null, null);
    }

    private String textPrivateFieldToHtml(FormField field) {
        return this.singleValueFieldToHtml(field, "password", null);
    }

    private String textMultiFieldToHtml(FormField field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.labelToHtml(field));
        sb.append("<textarea id='");
        sb.append(this.varToId(field.getVariable()));
        sb.append("' name='");
        sb.append(field.getVariable());
        sb.append("'>");
        boolean first = true;
        Iterator values = field.getValues();
        while (values.hasNext()) {
            if (!first) {
                sb.append("\r\n");
            }
            sb.append((String)values.next());
            first = false;
        }
        sb.append("</textarea>");
        return sb.toString();
    }

    private String listSingleFieldToHtml(FormField field) {
        Iterator fieldValues = field.getValues();
        ArrayList values = new ArrayList();
        if (fieldValues.hasNext()) {
            values.add(fieldValues.next());
        }
        return this.listFieldToHtml(field, values, false);
    }

    private String listMultiFieldToHtml(FormField field) {
        Iterator fieldValues = field.getValues();
        ArrayList values = new ArrayList();
        while (fieldValues.hasNext()) {
            values.add(fieldValues.next());
        }
        return this.listFieldToHtml(field, values, true);
    }

    private String listFieldToHtml(FormField field, List<String> values, boolean multiple) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.labelToHtml(field));
        sb.append("<select id='");
        sb.append(this.varToId(field.getVariable()));
        sb.append("' name='");
        sb.append(field.getVariable());
        sb.append("'");
        if (multiple) {
            sb.append(" multiple");
        }
        sb.append(">");
        Iterator options = field.getOptions();
        while (options.hasNext()) {
            FormField.Option option = (FormField.Option)options.next();
            sb.append("<option value='");
            sb.append(option.getValue());
            sb.append("'");
            if (values.contains(option.getValue())) {
                sb.append(" selected");
            }
            sb.append(">");
            if (option.getLabel() != null) {
                sb.append(option.getLabel());
            } else {
                sb.append(option.getValue());
            }
            sb.append("</option>");
        }
        sb.append("</select>");
        return sb.toString();
    }

    private String booleanFieldToHtml(FormField field) {
        StringBuilder sb = new StringBuilder();
        boolean value = field.getValues().hasNext() && "true".equals(field.getValues().next());
        sb.append(this.labelToHtml(field));
        sb.append("<input name='");
        sb.append(field.getVariable());
        sb.append("' value='true' type='radio' ");
        if (value) {
            sb.append("selected ");
        }
        sb.append("/> Yes ");
        sb.append("<input name='");
        sb.append(field.getVariable());
        sb.append("' value='false' type='radio' ");
        if (!value) {
            sb.append("selected ");
        }
        sb.append("/> No");
        return sb.toString();
    }

    private String singleValueFieldToHtml(FormField field, String type, String placeholder) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.labelToHtml(field));
        sb.append("<input id='");
        sb.append(this.varToId(field.getVariable()));
        sb.append("' name='");
        sb.append(field.getVariable());
        sb.append("' value='");
        sb.append(this.getSingleValue(field));
        sb.append("'");
        if (type != null) {
            sb.append(" type='" + type + "'");
        }
        if (placeholder != null) {
            sb.append(" placeholder='" + placeholder + "'");
        }
        sb.append(this.required(field));
        sb.append(" />");
        return sb.toString();
    }

    private String required(FormField field) {
        return field.isRequired() ? "required" : "";
    }

    private String getSingleValue(FormField field) {
        if (field.getValues().hasNext()) {
            return (String)field.getValues().next();
        }
        return "";
    }

    private String varToId(String var) {
        return var.replaceAll("[^A-Za-z0-9]", "-");
    }
}

