/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;
import org.apache.velocity.tools.generic.ValueParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultKey(value="params")
@ValidScope(value={"request"})
public class ParameterTool
extends ValueParser {
    private ServletRequest request;

    public ParameterTool() {
    }

    public ParameterTool(ServletRequest request) {
        this.setRequest(request);
    }

    @Override
    protected void configure(ValueParser values) {
        super.configure(values);
        ServletRequest req = (ServletRequest)values.get("request");
        this.setRequest(req);
    }

    public void setRequest(ServletRequest request) {
        this.request = request;
    }

    protected ServletRequest getRequest() {
        if (this.request == null) {
            throw new UnsupportedOperationException("Request is null. ParameterTool must be initialized first!");
        }
        return this.request;
    }

    @Override
    public Object getValue(String key) {
        Object value = this.getRequest().getParameter(key);
        if (value == null && this.getAllowSubkeys()) {
            value = this.getSubkey(key);
        }
        return value;
    }

    @Override
    public Object[] getValues(String key) {
        Object[] strings = this.getRequest().getParameterValues(key);
        if (strings == null || strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return this.parseStringList((String)strings[0]);
        }
        return strings;
    }

    protected void setSource(Map source) {
        throw new UnsupportedOperationException();
    }

    protected Map getSource() {
        return this.getRequest().getParameterMap();
    }

    public Map getAll() {
        return this.expandSingletonArrays(this.getSource());
    }

    @Override
    protected ValueParser getSubkey(String subkey) {
        ValueParser submap = super.getSubkey(subkey);
        if (submap != null) {
            submap = new ValueParser(this.expandSingletonArrays(submap));
        }
        return submap;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Collection values() {
        HashSet<Object> result = new HashSet<Object>();
        for (Object value : super.values()) {
            if (this.isSingletonArray(value)) {
                result.add(Array.get(value, 0));
                continue;
            }
            result.add(value);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.expandSingletonArrays(this.getSource()).entrySet();
    }

    private boolean isSingletonArray(Object value) {
        return value != null && value.getClass().isArray() && Array.getLength(value) == 1;
    }

    private Map<String, Object> expandSingletonArrays(Map<String, Object> original) {
        HashMap<String, Object> expanded = new HashMap<String, Object>(original);
        for (Map.Entry entry : expanded.entrySet()) {
            Object value = entry.getValue();
            if (!this.isSingletonArray(value)) continue;
            entry.setValue(Array.get(value, 0));
        }
        return expanded;
    }
}

