/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(StandardService.class);
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private String name = null;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private Server server = null;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    protected ArrayList<Executor> executors = new ArrayList();
    protected Container container = null;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        if (oldContainer != null && oldContainer instanceof Engine) {
            ((Engine)oldContainer).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.getState().isAvailable() && this.container != null) {
            try {
                this.container.start();
            }
            catch (LifecycleException e) {
                // empty catch block
            }
        }
        if (this.getState().isAvailable() && oldContainer != null) {
            try {
                oldContainer.stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.getState().isAvailable()) {
                try {
                    connector.start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Connector.start", (Throwable)e);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.connectors[i].getObjectName();
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int j = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (connector != this.connectors[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.getState().isAvailable()) {
                try {
                    this.connectors[j].stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Connector.stop", (Throwable)e);
                }
            }
            connector.setService(null);
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == j) continue;
                results[k++] = this.connectors[i];
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(ex)) {
                this.executors.add(ex);
                if (this.getState().isAvailable()) {
                    try {
                        ex.start();
                    }
                    catch (LifecycleException x) {
                        log.error((Object)"Executor.start", (Throwable)x);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            Executor[] arr = new Executor[this.executors.size()];
            this.executors.toArray(arr);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String name) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (int i = 0; i < this.executors.size(); ++i) {
                if (!name.equals(this.executors.get(i).getName())) continue;
                return this.executors.get(i);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(ex) && this.getState().isAvailable()) {
                try {
                    ex.stop();
                }
                catch (LifecycleException e) {
                    log.error((Object)"Executor.stop", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        int i;
        Connector[] connectorArray;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.start.name", new Object[]{this.name}));
        }
        this.setState(LifecycleState.STARTING);
        if (this.container != null) {
            connectorArray = this.container;
            synchronized (connectorArray) {
                this.container.start();
            }
        }
        connectorArray = this.executors;
        synchronized (connectorArray) {
            for (i = 0; i < this.executors.size(); ++i) {
                this.executors.get(i).start();
            }
        }
        connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        Object object = this.connectors;
        synchronized (this.connectors) {
            int i;
            for (i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].pause();
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("standardService.stop.name", new Object[]{this.name}));
            }
            this.setState(LifecycleState.STOPPING);
            if (this.container != null) {
                object = this.container;
                synchronized (object) {
                    this.container.stop();
                }
            }
            object = this.connectors;
            synchronized (this.connectors) {
                for (i = 0; i < this.connectors.length; ++i) {
                    if (LifecycleState.INITIALIZED.equals((Object)this.connectors[i].getState())) continue;
                    this.connectors[i].stop();
                }
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                object = this.executors;
                synchronized (object) {
                    for (i = 0; i < this.executors.size(); ++i) {
                        this.executors.get(i).stop();
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.container.init();
        }
        for (Executor executor : this.findExecutors()) {
            if (executor instanceof LifecycleMBeanBase) {
                ((LifecycleMBeanBase)((Object)executor)).setDomain(this.getDomain());
            }
            executor.init();
        }
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (Connector connector : this.connectors) {
                try {
                    connector.init();
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("standardService.connector.initFailed", new Object[]{connector}), (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyInternal() throws LifecycleException {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (Connector connector : this.connectors) {
                try {
                    connector.destroy();
                }
                catch (Exception e) {
                    log.error((Object)sm.getString("standardService.connector.destroyfailed", new Object[]{connector}), (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (Executor executor : this.findExecutors()) {
                executor.destroy();
            }
            if (this.container != null) {
                this.container.destroy();
            }
            super.destroyInternal();
            return;
        }
    }

    @Override
    protected String getDomainInternal() {
        return MBeanUtils.getDomain(this);
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }
}

