/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.request.attribute.HasAddableKeys;
import org.apache.tiles.request.collection.ReadOnlyEnumerationMap;

public class AddableParameterMap
extends ReadOnlyEnumerationMap<String> {
    private HasAddableKeys<String> request;

    public AddableParameterMap(HasAddableKeys<String> request) {
        super(request);
        this.request = request;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AddableParameterEntrySet();
    }

    @Override
    public String put(String key, String value) {
        String oldValue = (String)this.request.getValue(key);
        this.request.setValue(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        for (Map.Entry<? extends String, ? extends String> entry : map.entrySet()) {
            this.request.setValue(entry.getKey(), entry.getValue());
        }
    }

    private class AddableParameterEntrySet
    extends ReadOnlyEnumerationMap.ReadOnlyEnumerationMapEntrySet {
        private AddableParameterEntrySet() {
            super(AddableParameterMap.this);
        }

        @Override
        public boolean add(Map.Entry<String, String> e) {
            AddableParameterMap.this.request.setValue(e.getKey(), e.getValue());
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, String>> c) {
            for (Map.Entry<String, String> entry : c) {
                AddableParameterMap.this.request.setValue(entry.getKey(), entry.getValue());
            }
            return true;
        }
    }
}

