/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.beanvalidator;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.beanvalidator.BeanValidatorGroupSource;
import org.apache.tapestry5.beanvalidator.ClientConstraintDescriptor;
import org.apache.tapestry5.beanvalidator.ClientConstraintDescriptorSource;
import org.apache.tapestry5.internal.BeanValidationContext;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.FormSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanFieldValidator
implements FieldValidator {
    private final Field field;
    private final ValidatorFactory validatorFactory;
    private final BeanValidatorGroupSource beanValidationGroupSource;
    private final ClientConstraintDescriptorSource clientValidatorSource;
    private final FormSupport formSupport;
    private final Environment environment;

    public BeanFieldValidator(Field field, ValidatorFactory validatorFactory, BeanValidatorGroupSource beanValidationGroupSource, ClientConstraintDescriptorSource clientValidatorSource, FormSupport formSupport, Environment environment) {
        this.field = field;
        this.validatorFactory = validatorFactory;
        this.beanValidationGroupSource = beanValidationGroupSource;
        this.clientValidatorSource = clientValidatorSource;
        this.formSupport = formSupport;
        this.environment = environment;
    }

    public boolean isRequired() {
        return false;
    }

    public void render(MarkupWriter writer) {
        BeanValidationContext beanValidationContext = (BeanValidationContext)this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext == null) {
            return;
        }
        Validator validator = this.validatorFactory.getValidator();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(beanValidationContext.getBeanType());
        String currentProperty = beanValidationContext.getCurrentProperty();
        if (currentProperty == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(currentProperty);
        if (propertyDescriptor == null) {
            return;
        }
        for (ConstraintDescriptor descriptor : propertyDescriptor.getConstraintDescriptors()) {
            Class<? extends Annotation> annotationType = descriptor.getAnnotation().annotationType();
            ClientConstraintDescriptor clientConstraintDescriptor = this.clientValidatorSource.getConstraintDescriptor(annotationType);
            if (clientConstraintDescriptor == null) continue;
            String message = String.format("%s %s", this.field.getLabel(), this.interpolateMessage(descriptor));
            JSONObject specs = new JSONObject();
            for (String attribute : clientConstraintDescriptor.getAttributes()) {
                Object object = descriptor.getAttributes().get(attribute);
                if (object == null) {
                    throw new RuntimeException("Expected attribute is null");
                }
                specs.put(attribute, object);
            }
            this.formSupport.addValidation(this.field, clientConstraintDescriptor.getValidatorName(), message, (Object)specs);
        }
    }

    public void validate(Object value) throws ValidationException {
        BeanValidationContext beanValidationContext = (BeanValidationContext)this.environment.peek(BeanValidationContext.class);
        if (beanValidationContext == null) {
            return;
        }
        Validator validator = this.validatorFactory.getValidator();
        String currentProperty = beanValidationContext.getCurrentProperty();
        if (currentProperty == null) {
            return;
        }
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(beanValidationContext.getBeanType());
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(currentProperty);
        if (propertyDescriptor == null) {
            return;
        }
        Set violations = validator.validateValue(beanValidationContext.getBeanType(), currentProperty, value, (Class[])this.beanValidationGroupSource.get());
        if (violations.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        Iterator iterator = violations.iterator();
        while (iterator.hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            builder.append(String.format("%s %s", this.field.getLabel(), violation.getMessage()));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        throw new ValidationException(builder.toString());
    }

    private String interpolateMessage(final ConstraintDescriptor<?> descriptor) {
        String messageTemplate = (String)descriptor.getAttributes().get("message");
        MessageInterpolator messageInterpolator = this.validatorFactory.getMessageInterpolator();
        return messageInterpolator.interpolate(messageTemplate, new MessageInterpolator.Context(){

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return descriptor;
            }

            public Object getValidatedValue() {
                return null;
            }
        });
    }
}

