/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.ServletActionRedirectResult;

public class JSONActionRedirectResult
extends ServletActionRedirectResult {
    private static final long serialVersionUID = 3107276294073879542L;

    protected void sendRedirect(HttpServletResponse response, String finalLocation) throws IOException {
        if (this.sendJsonInsteadOfRedirect()) {
            this.printJson(response, finalLocation);
        } else {
            super.sendRedirect(response, finalLocation);
        }
    }

    protected boolean sendJsonInsteadOfRedirect() {
        HttpServletRequest request = ServletActionContext.getRequest();
        return this.isJsonEnabled(request) && !this.isValidateOnly(request);
    }

    protected void printJson(HttpServletResponse response, String finalLocation) throws IOException {
        response.setStatus(200);
        response.setContentType("application/json");
        response.setHeader("Location", finalLocation);
        PrintWriter writer = response.getWriter();
        writer.write("{\"location\": \"");
        writer.write(finalLocation);
        writer.write("\"}");
        writer.close();
    }

    protected boolean isJsonEnabled(HttpServletRequest request) {
        return "true".equals(request.getParameter("struts.enableJSONValidation"));
    }

    protected boolean isValidateOnly(HttpServletRequest request) {
        return "true".equals(request.getParameter("struts.validateOnly"));
    }
}

