/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kinesis.spout;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.storm.kinesis.spout.ZkInfo;
import org.apache.zookeeper.CreateMode;
import org.json.simple.JSONValue;

class ZKConnection {
    private final ZkInfo zkInfo;
    private CuratorFramework curatorFramework;

    ZKConnection(ZkInfo zkInfo) {
        this.zkInfo = zkInfo;
    }

    void initialize() {
        this.curatorFramework = CuratorFrameworkFactory.newClient((String)this.zkInfo.getZkUrl(), (int)this.zkInfo.getSessionTimeoutMs(), (int)this.zkInfo.getConnectionTimeoutMs(), (RetryPolicy)new RetryNTimes(this.zkInfo.getRetryAttempts().intValue(), this.zkInfo.getRetryIntervalMs().intValue()));
        this.curatorFramework.start();
    }

    void commitState(String stream, String shardId, Map<Object, Object> state) {
        byte[] bytes = JSONValue.toJSONString(state).getBytes(Charset.forName("UTF-8"));
        try {
            String path = this.getZkPath(stream, shardId);
            if (this.curatorFramework.checkExists().forPath(path) == null) {
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, bytes);
            } else {
                this.curatorFramework.setData().forPath(path, bytes);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Map<Object, Object> readState(String stream, String shardId) {
        try {
            String path = this.getZkPath(stream, shardId);
            Map state = null;
            byte[] b = null;
            if (this.curatorFramework.checkExists().forPath(path) != null) {
                b = (byte[])this.curatorFramework.getData().forPath(path);
            }
            if (b != null) {
                state = (Map)JSONValue.parseWithException((String)new String(b, "UTF-8"));
            }
            return state;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void shutdown() {
        this.curatorFramework.close();
    }

    private String getZkPath(String stream, String shardId) {
        String path = "";
        if (!this.zkInfo.getZkNode().startsWith("/")) {
            path = path + "/";
        }
        path = path + this.zkInfo.getZkNode();
        if (!this.zkInfo.getZkNode().endsWith("/")) {
            path = path + "/";
        }
        path = path + stream + "/" + shardId;
        return path;
    }
}

