/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.refresher.type.table;

import java.util.Collection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.connection.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.connection.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;

public final class DropTableStatementSchemaRefresher
implements MetaDataRefresher<DropTableStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, DropTableStatement sqlStatement, ConfigurationProperties props) {
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName);
        sqlStatement.getTables().forEach(each -> alterSchemaMetaDataPOJO.getDroppedTables().add(each.getTableName().getIdentifier().getValue()));
        boolean isRuleRefreshRequired = TableRefreshUtils.isRuleRefreshRequired(database.getRuleMetaData(), schemaName, sqlStatement.getTables());
        modeContextManager.alterSchemaMetaData(alterSchemaMetaDataPOJO);
        for (SimpleTableSegment each2 : sqlStatement.getTables()) {
            if (!isRuleRefreshRequired || !TableRefreshUtils.isSingleTable(each2.getTableName().getIdentifier().getValue(), database)) continue;
            modeContextManager.alterSingleRuleConfiguration(database.getName(), database.getRuleMetaData().getConfigurations());
            break;
        }
    }

    @Override
    public Class<DropTableStatement> getType() {
        return DropTableStatement.class;
    }
}

