/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.util;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.metadata.database.system.SystemDatabase;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.database.opengauss.type.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;

public final class SystemSchemaUtils {
    private static final Collection<String> SYSTEM_CATALOG_QUERY_EXPRESSIONS = new HashSet<String>(3, 1.0f);

    public static boolean containsSystemSchema(DatabaseType databaseType, Collection<String> schemaNames, ShardingSphereDatabase database) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        if (database.isComplete() && !dialectDatabaseMetaData.getDefaultSchema().isPresent()) {
            return false;
        }
        SystemDatabase systemDatabase = new SystemDatabase(databaseType);
        for (String each : schemaNames) {
            if (!systemDatabase.getSystemSchemas().contains(each)) continue;
            return true;
        }
        return !dialectDatabaseMetaData.getDefaultSchema().isPresent() && systemDatabase.getSystemSchemas().contains(database.getName());
    }

    public static boolean isOpenGaussSystemCatalogQuery(DatabaseType databaseType, Collection<ProjectionSegment> projections) {
        if (!(databaseType instanceof OpenGaussDatabaseType)) {
            return false;
        }
        return 1 == projections.size() && projections.iterator().next() instanceof ExpressionProjectionSegment && SYSTEM_CATALOG_QUERY_EXPRESSIONS.contains(((ExpressionProjectionSegment)projections.iterator().next()).getText().toLowerCase());
    }

    public static boolean isSystemSchema(ShardingSphereDatabase database) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(database.getProtocolType()).getDialectDatabaseMetaData();
        if (database.isComplete() && !dialectDatabaseMetaData.getDefaultSchema().isPresent()) {
            return false;
        }
        return new SystemDatabase(database.getProtocolType()).getSystemSchemas().contains(database.getName());
    }

    @Generated
    private SystemSchemaUtils() {
    }

    static {
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("version()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("intervaltonum(gs_password_deadline())");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("gs_password_notifytime()");
    }
}

