/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.datanode.InvalidDataNodeFormatException;

public final class DataNode {
    private static final String DELIMITER = ".";
    private static final String ASTERISK = "*";
    private final String dataSourceName;
    private final String tableName;
    private String schemaName;

    public DataNode(String dataNode) {
        boolean isIncludeInstance = this.isActualDataNodesIncludedDataSourceInstance(dataNode);
        if (!isIncludeInstance && !this.isValidDataNode(dataNode, 2)) {
            throw new InvalidDataNodeFormatException(dataNode);
        }
        if (isIncludeInstance && !this.isValidDataNode(dataNode, 3)) {
            throw new InvalidDataNodeFormatException(dataNode);
        }
        List segments = Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNode);
        this.dataSourceName = isIncludeInstance ? (String)segments.get(0) + DELIMITER + (String)segments.get(1) : (String)segments.get(0);
        this.tableName = (String)segments.get(isIncludeInstance ? 2 : 1);
    }

    public DataNode(String databaseName, DatabaseType databaseType, String dataNode) {
        ShardingSpherePreconditions.checkState((boolean)dataNode.contains(DELIMITER), () -> new InvalidDataNodeFormatException(dataNode));
        boolean containsSchema = this.isValidDataNode(dataNode, 3);
        List segments = Splitter.on((String)DELIMITER).splitToList((CharSequence)dataNode);
        this.dataSourceName = (String)segments.get(0);
        this.schemaName = this.getSchemaName(databaseName, databaseType, containsSchema, segments);
        this.tableName = containsSchema ? ((String)segments.get(2)).toLowerCase() : ((String)segments.get(1)).toLowerCase();
    }

    private String getSchemaName(String databaseName, DatabaseType databaseType, boolean containsSchema, List<String> segments) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        if (dialectDatabaseMetaData.getDefaultSchema().isPresent()) {
            return containsSchema ? segments.get(1) : ASTERISK;
        }
        return databaseName;
    }

    private boolean isValidDataNode(String dataNodeStr, Integer tier) {
        return dataNodeStr.contains(DELIMITER) && tier.intValue() == Splitter.on((String)DELIMITER).omitEmptyStrings().splitToList((CharSequence)dataNodeStr).size();
    }

    private boolean isActualDataNodesIncludedDataSourceInstance(String actualDataNodes) {
        return this.isValidDataNode(actualDataNodes, 3);
    }

    public String format() {
        return this.dataSourceName + DELIMITER + this.tableName;
    }

    public String format(DatabaseType databaseType) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData();
        return dialectDatabaseMetaData.getDefaultSchema().isPresent() ? this.dataSourceName + DELIMITER + this.schemaName + DELIMITER + this.tableName : this.dataSourceName + DELIMITER + this.tableName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || this.getClass() != object.getClass()) {
            return false;
        }
        DataNode dataNode = (DataNode)object;
        return Objects.equal((Object)this.dataSourceName.toUpperCase(), (Object)dataNode.dataSourceName.toUpperCase()) && Objects.equal((Object)this.tableName.toUpperCase(), (Object)dataNode.tableName.toUpperCase()) && Objects.equal((Object)(null == this.schemaName ? null : this.schemaName.toUpperCase()), null == dataNode.schemaName ? null : dataNode.schemaName.toUpperCase());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dataSourceName.toUpperCase(), this.tableName.toUpperCase(), null == this.schemaName ? null : this.schemaName.toUpperCase()});
    }

    @Generated
    public DataNode(String dataSourceName, String tableName) {
        this.dataSourceName = dataSourceName;
        this.tableName = tableName;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public String toString() {
        return "DataNode(dataSourceName=" + this.getDataSourceName() + ", tableName=" + this.getTableName() + ", schemaName=" + this.getSchemaName() + ")";
    }
}

