/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import org.apache.pluto.container.ContainerServices;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.impl.PortletContainerImpl;
import org.apache.pluto.container.util.ArgumentUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletContainerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PortletContainerFactory.class);
    private static final PortletContainerFactory FACTORY = new PortletContainerFactory();

    public static PortletContainerFactory getInstance() {
        return FACTORY;
    }

    private PortletContainerFactory() {
    }

    public PortletContainer createContainer(String containerName, ContainerServices requiredServices) throws PortletContainerException {
        ArgumentUtility.validateNotNull("requiredServices", requiredServices);
        ArgumentUtility.validateNotEmpty("containerName", containerName);
        PortletContainerImpl container = new PortletContainerImpl(containerName, requiredServices);
        if (LOG.isInfoEnabled()) {
            LOG.info("Portlet Container [" + containerName + "] created.");
        }
        return container;
    }
}

