/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class XWPFTable {
    protected StringBuffer text = new StringBuffer();
    private CTTbl ctTbl;

    public XWPFTable(CTTbl table, int row, int col) {
        this(table);
        for (int i = 0; i < row; ++i) {
            XWPFTableRow tabRow = this.getRow(i) == null ? this.createRow() : this.getRow(i);
            for (int k = 0; k < col; ++k) {
                XWPFTableCell tabCell = tabRow.getCell(k) == null ? tabRow.createCell() : null;
            }
        }
    }

    public XWPFTable(CTTbl table) {
        this.ctTbl = table;
        if (table.sizeOfTrArray() == 0) {
            this.createEmptyTable(table);
        }
        for (CTRow row : table.getTrArray()) {
            StringBuffer rowText = new StringBuffer();
            for (CTTc cell : row.getTcArray()) {
                for (CTP ctp : cell.getPArray()) {
                    XWPFParagraph p = new XWPFParagraph(ctp, null);
                    if (rowText.length() > 0) {
                        rowText.append('\t');
                    }
                    rowText.append(p.getText());
                }
            }
            if (rowText.length() <= 0) continue;
            this.text.append(rowText);
            this.text.append('\n');
        }
    }

    private void createEmptyTable(CTTbl table) {
        table.addNewTr().addNewTc().addNewP();
        CTTblPr tblpro = table.addNewTblPr();
        tblpro.addNewTblW().setW(new BigInteger("0"));
        tblpro.getTblW().setType(STTblWidth.AUTO);
        CTTblBorders borders = tblpro.addNewTblBorders();
        borders.addNewBottom().setVal(STBorder.SINGLE);
        borders.addNewInsideH().setVal(STBorder.SINGLE);
        borders.addNewInsideV().setVal(STBorder.SINGLE);
        borders.addNewLeft().setVal(STBorder.SINGLE);
        borders.addNewRight().setVal(STBorder.SINGLE);
        borders.addNewTop().setVal(STBorder.SINGLE);
    }

    public CTTbl getCTTbl() {
        return this.ctTbl;
    }

    public String getText() {
        return this.text.toString();
    }

    public void addNewRowBetween(int start, int end) {
    }

    public void addNewCol() {
        if (this.ctTbl.sizeOfTrArray() == 0) {
            this.createRow();
        }
        for (int i = 0; i < this.ctTbl.sizeOfTrArray(); ++i) {
            XWPFTableRow tabRow = new XWPFTableRow(this.ctTbl.getTrArray(i));
            tabRow.createCell();
        }
    }

    public XWPFTableRow createRow() {
        int sizeCol = this.ctTbl.sizeOfTrArray() > 0 ? this.ctTbl.getTrArray(0).sizeOfTcArray() : 0;
        XWPFTableRow tabRow = new XWPFTableRow(this.ctTbl.addNewTr());
        this.addColumn(tabRow, sizeCol);
        return tabRow;
    }

    public XWPFTableRow getRow(int pos) {
        if (pos >= 0 && pos < this.ctTbl.sizeOfTrArray()) {
            return new XWPFTableRow(this.ctTbl.getTrArray(pos));
        }
        return null;
    }

    public void setWidth(int width) {
        CTTblPr tblPr = this.getTrPr();
        CTTblWidth tblWidth = tblPr.isSetTblW() ? tblPr.getTblW() : tblPr.addNewTblW();
        tblWidth.setW(new BigInteger("" + width));
    }

    public int getWidth() {
        CTTblPr tblPr = this.getTrPr();
        return tblPr.isSetTblW() ? tblPr.getTblW().getW().intValue() : -1;
    }

    public int getNumberOfRows() {
        return this.ctTbl.sizeOfTrArray();
    }

    private CTTblPr getTrPr() {
        return this.ctTbl.getTblPr() != null ? this.ctTbl.getTblPr() : this.ctTbl.addNewTblPr();
    }

    private void addColumn(XWPFTableRow tabRow, int sizeCol) {
        if (sizeCol > 0) {
            for (int i = 0; i < sizeCol; ++i) {
                tabRow.createCell();
            }
        }
    }
}

