/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractEmbeddedFiles {
    private ExtractEmbeddedFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            ExtractEmbeddedFiles.usage();
            System.exit(1);
        } else {
            PDDocument document = null;
            try {
                PDDocumentNameDictionary namesDictionary;
                PDEmbeddedFilesNameTreeNode efTree;
                File pdfFile = new File(args[0]);
                String filePath = pdfFile.getParent() + System.getProperty("file.separator");
                document = PDDocument.load((File)pdfFile);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (CryptographyException e) {
                        e.printStackTrace();
                    }
                }
                if ((efTree = (namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog())).getEmbeddedFiles()) != null) {
                    Map names = efTree.getNames();
                    if (names != null) {
                        ExtractEmbeddedFiles.extractFiles(names, filePath);
                    } else {
                        List kids = efTree.getKids();
                        for (PDNameTreeNode node : kids) {
                            names = node.getNames();
                            ExtractEmbeddedFiles.extractFiles(names, filePath);
                        }
                    }
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void extractFiles(Map<String, COSObjectable> names, String filePath) throws IOException {
        for (String filename : names.keySet()) {
            PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)names.get(filename);
            PDEmbeddedFile embeddedFile = ExtractEmbeddedFiles.getEmbeddedFile(fileSpec);
            String embeddedFilename = filePath + filename;
            File file = new File(filePath + filename);
            System.out.println("Writing " + embeddedFilename);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(embeddedFile.getByteArray());
            fos.close();
        }
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    private static void usage() {
        System.err.println("Usage: java " + ExtractEmbeddedFiles.class.getName() + " <input-pdf>");
    }
}

