/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.util.PDFTextStripper;
import org.apache.pdfbox.util.TextPosition;

public class PrintTextLocations
extends PDFTextStripper {
    public PrintTextLocations() throws IOException {
        super.setSortByPosition(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            PrintTextLocations.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((String)args[0]);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: Document is encrypted with a password.");
                        System.exit(1);
                    }
                }
                PrintTextLocations printer = new PrintTextLocations();
                List allPages = document.getDocumentCatalog().getAllPages();
                for (int i = 0; i < allPages.size(); ++i) {
                    PDPage page = (PDPage)allPages.get(i);
                    System.out.println("Processing page: " + i);
                    PDStream contents = page.getContents();
                    if (contents == null) continue;
                    printer.processStream(page, page.findResources(), page.getContents().getStream());
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    protected void processTextPosition(TextPosition text) {
        System.out.println("String[" + text.getXDirAdj() + "," + text.getYDirAdj() + " fs=" + text.getFontSize() + " xscale=" + text.getXScale() + " height=" + text.getHeightDir() + " space=" + text.getWidthOfSpace() + " width=" + text.getWidthDirAdj() + "]" + text.getCharacter());
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.PrintTextLocations <input-pdf>");
    }
}

