/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.identifier;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.lib.identifier.Identifier;

public class QualifiedDBIdentifier
extends DBIdentifier
implements Identifier,
Cloneable,
Serializable {
    private DBIdentifier _schemaName = DBIdentifier.NULL;
    private DBIdentifier _objectTableName = DBIdentifier.NULL;

    protected QualifiedDBIdentifier(DBIdentifier ... sNames) {
        this.setPath(sNames);
    }

    public static QualifiedDBIdentifier newPath(DBIdentifier ... names) {
        return new QualifiedDBIdentifier(names);
    }

    public void setPath(DBIdentifier ... sNames) {
        this.resetNames();
        if (sNames == null || sNames.length == 0) {
            return;
        }
        if (sNames.length == 1) {
            DBIdentifier sName = sNames[0];
            if (sName.getType() == DBIdentifier.DBIdentifierType.SCHEMA) {
                this.setSchemaName(sName.clone());
            }
            this.setName(sName.clone());
            this.setType(sName.getType());
            return;
        }
        for (int i = sNames.length - 1; i >= 0; --i) {
            DBIdentifier sName = sNames[i];
            if (DBIdentifier.isNull(sName)) continue;
            if (i == sNames.length - 1 && sNames.length != 1) {
                this.setName(sName.clone());
                continue;
            }
            if (sName.getType() == DBIdentifier.DBIdentifierType.SCHEMA) {
                this.setSchemaName(sName.clone());
                continue;
            }
            if (sName.getType() != DBIdentifier.DBIdentifierType.TABLE) continue;
            this.setObjectTableName(sName.clone());
        }
    }

    private void resetNames() {
        this._schemaName = DBIdentifier.NULL;
        this._objectTableName = DBIdentifier.NULL;
    }

    public static DBIdentifier[] splitPath(DBIdentifier sName) {
        if (sName instanceof QualifiedDBIdentifier && sName.getType() != DBIdentifier.DBIdentifierType.SCHEMA) {
            QualifiedDBIdentifier path = (QualifiedDBIdentifier)sName;
            ArrayList<DBIdentifier> names = new ArrayList<DBIdentifier>();
            if (!DBIdentifier.isNull(path.getSchemaName())) {
                names.add(path.getSchemaName().clone());
            }
            if (!DBIdentifier.isNull(path.getObjectTableName())) {
                names.add(path.getObjectTableName().clone());
            }
            if (!DBIdentifier.isNull(path.getIdentifier())) {
                names.add(((DBIdentifier)path).clone());
            }
            return names.toArray(new DBIdentifier[names.size()]);
        }
        if (sName instanceof DBIdentifier) {
            return new DBIdentifier[]{sName.clone()};
        }
        return new DBIdentifier[0];
    }

    public static QualifiedDBIdentifier getPath(DBIdentifier sName) {
        if (sName instanceof QualifiedDBIdentifier) {
            return (QualifiedDBIdentifier)sName.clone();
        }
        return QualifiedDBIdentifier.newPath(sName);
    }

    public void setSchemaName(DBIdentifier schemaName) {
        this._schemaName = schemaName;
    }

    public DBIdentifier getSchemaName() {
        return this._schemaName;
    }

    public void setObjectTableName(DBIdentifier objectName) {
        this._objectTableName = objectName;
    }

    public DBIdentifier getObjectTableName() {
        return this._objectTableName;
    }

    public boolean isUnqualifiedObject() {
        return DBIdentifier.isNull(this.getSchemaName());
    }

    public boolean isUnqualifiedColumn() {
        return DBIdentifier.isNull(this.getObjectTableName()) && DBIdentifier.isNull(this.getSchemaName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof QualifiedDBIdentifier) {
            QualifiedDBIdentifier sPath = (QualifiedDBIdentifier)obj;
            return DBIdentifier.equal(sPath.getSchemaName(), this.getSchemaName()) && DBIdentifier.equal(sPath.getObjectTableName(), this.getObjectTableName()) && DBIdentifier.equal(sPath, this);
        }
        if (obj instanceof DBIdentifier) {
            DBIdentifier sName = (DBIdentifier)obj;
            return DBIdentifier.equal(sName, this);
        }
        if (obj instanceof String) {
            return obj.equals(this.getName());
        }
        throw new IllegalArgumentException("Cannot compare to type: " + obj.getClass().getName());
    }

    public static boolean pathEqual(QualifiedDBIdentifier path1, QualifiedDBIdentifier path2) {
        DBIdentifier[] names2;
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null) {
            return false;
        }
        DBIdentifier[] names1 = QualifiedDBIdentifier.splitPath(path1);
        if (names1.length != (names2 = QualifiedDBIdentifier.splitPath(path2)).length) {
            return false;
        }
        for (int i = 0; i < names1.length; ++i) {
            if (DBIdentifier.equal(names1[i], names2[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        if (DBIdentifier.isEmpty(this._schemaName) && DBIdentifier.isEmpty(this._objectTableName)) {
            return this.getBaseName();
        }
        DBIdentifier[] names = QualifiedDBIdentifier.splitPath(this);
        return DBIdentifier.join(names);
    }

    public String getBaseName() {
        return super.getName();
    }

    public DBIdentifier getIdentifier() {
        return this;
    }

    @Override
    public void setName(String name) {
        DBIdentifier[] sNames = DBIdentifier.split(this.getType(), name);
        this.setPath(sNames);
    }

    protected void setBaseName(String name) {
        super.setName(name);
    }

    @Override
    public int length() {
        String name = this.getName();
        if (name == null) {
            return 0;
        }
        return name.length();
    }

    @Override
    public int compareTo(Identifier o) {
        if (o instanceof DBIdentifier) {
            if (o == null || o == DBIdentifier.NULL) {
                return -1;
            }
            return super.compareTo(o);
        }
        return this.getName().compareTo(o.getName());
    }

    @Override
    public boolean isDelimited() {
        if (DBIdentifier.isEmpty(this)) {
            return false;
        }
        if (!DBIdentifier.isNull(this.getObjectTableName()) && !Normalizer.isDelimited(this.getObjectTableName().getName())) {
            return false;
        }
        if (!DBIdentifier.isNull(this.getSchemaName()) && !Normalizer.isDelimited(this.getSchemaName().getName())) {
            return false;
        }
        return super.isDelimited();
    }

    @Override
    public DBIdentifier getUnqualifiedName() {
        QualifiedDBIdentifier newName = this.clone();
        newName.setObjectTableName(DBIdentifier.NULL);
        newName.setSchemaName(DBIdentifier.NULL);
        return newName;
    }

    @Override
    public QualifiedDBIdentifier clone() {
        QualifiedDBIdentifier sPath = new QualifiedDBIdentifier(new DBIdentifier[0]);
        sPath.setObjectTableName(this.getObjectTableName().clone());
        sPath.setSchemaName(this.getSchemaName().clone());
        sPath.setBaseName(super.getName());
        sPath.setType(this.getType());
        sPath.setIgnoreCase(this.getIgnoreCase());
        return sPath;
    }
}

