/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi;

import java.lang.ref.WeakReference;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSingletonService
implements SingletonService<WebBeansContext> {
    private final Map<ClassLoader, WebBeansContext> singletonMap = new WeakHashMap<ClassLoader, WebBeansContext>();
    private final Map<Object, WeakReference<ClassLoader>> objectToClassLoaderMap = new IdentityHashMap<Object, WeakReference<ClassLoader>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebBeansContext get(Object key) {
        this.assertClassLoaderKey(key);
        ClassLoader classLoader = (ClassLoader)key;
        Map<ClassLoader, WebBeansContext> map = this.singletonMap;
        synchronized (map) {
            WebBeansContext webBeansContext = this.singletonMap.get(classLoader);
            if (webBeansContext == null) {
                webBeansContext = new WebBeansContext();
                this.singletonMap.put(classLoader, webBeansContext);
            }
            return webBeansContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInstances(ClassLoader classLoader) {
        Asserts.assertNotNull(classLoader, "classloader is null");
        Map<ClassLoader, WebBeansContext> map = this.singletonMap;
        synchronized (map) {
            this.singletonMap.remove(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getSingletonClassLoader(Object object) {
        Asserts.assertNotNull(object, "object is null");
        Map<Object, WeakReference<ClassLoader>> map = this.objectToClassLoaderMap;
        synchronized (map) {
            WeakReference<ClassLoader> current;
            if (this.objectToClassLoaderMap.containsKey(object) && (current = this.objectToClassLoaderMap.get(object)) != null) {
                return (ClassLoader)current.get();
            }
        }
        return null;
    }

    @Override
    public void clear(Object classLoader) {
        this.assertClassLoaderKey(classLoader);
        this.clearInstances((ClassLoader)classLoader);
    }

    private void assertClassLoaderKey(Object key) {
        if (!(key instanceof ClassLoader)) {
            throw new IllegalArgumentException("Key instance must be ClassLoader for using DefaultSingletonService");
        }
    }
}

